/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateSpecification;

public class LaunchTemplateSpecificationUnmarshaller
implements Unmarshaller<LaunchTemplateSpecification, StaxUnmarshallerContext> {
    private static final LaunchTemplateSpecificationUnmarshaller INSTANCE = new LaunchTemplateSpecificationUnmarshaller();

    public LaunchTemplateSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LaunchTemplateSpecification.Builder launchTemplateSpecification = LaunchTemplateSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("LaunchTemplateId", targetDepth)) {
                    launchTemplateSpecification.launchTemplateId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LaunchTemplateName", targetDepth)) {
                    launchTemplateSpecification.launchTemplateName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Version", targetDepth)) continue;
                launchTemplateSpecification.version(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LaunchTemplateSpecification)launchTemplateSpecification.build();
    }

    public static LaunchTemplateSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

