/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.HistoryRecordEntry;
import software.amazon.awssdk.services.ec2.transform.EventInformationUnmarshaller;

public class HistoryRecordEntryUnmarshaller
implements Unmarshaller<HistoryRecordEntry, StaxUnmarshallerContext> {
    private static final HistoryRecordEntryUnmarshaller INSTANCE = new HistoryRecordEntryUnmarshaller();

    public HistoryRecordEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        HistoryRecordEntry.Builder historyRecordEntry = HistoryRecordEntry.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("eventInformation", targetDepth)) {
                    historyRecordEntry.eventInformation(EventInformationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("eventType", targetDepth)) {
                    historyRecordEntry.eventType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("timestamp", targetDepth)) continue;
                historyRecordEntry.timestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (HistoryRecordEntry)historyRecordEntry.build();
    }

    public static HistoryRecordEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

