/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest;

public class GetLaunchTemplateDataRequestMarshaller
implements Marshaller<Request<GetLaunchTemplateDataRequest>, GetLaunchTemplateDataRequest> {
    public Request<GetLaunchTemplateDataRequest> marshall(GetLaunchTemplateDataRequest getLaunchTemplateDataRequest) {
        if (getLaunchTemplateDataRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getLaunchTemplateDataRequest, "Ec2Client");
        request.addParameter("Action", "GetLaunchTemplateData");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getLaunchTemplateDataRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)getLaunchTemplateDataRequest.instanceId()));
        }
        return request;
    }
}

