/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.FleetData;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfig;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.FleetLaunchTemplateConfigUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.OnDemandOptionsUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.SpotOptionsUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TargetCapacitySpecificationUnmarshaller;

public class FleetDataUnmarshaller
implements Unmarshaller<FleetData, StaxUnmarshallerContext> {
    private static final FleetDataUnmarshaller INSTANCE = new FleetDataUnmarshaller();

    public FleetData unmarshall(StaxUnmarshallerContext context) throws Exception {
        FleetData.Builder fleetData;
        block23: {
            fleetData = FleetData.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<FleetLaunchTemplateConfig> launchTemplateConfigs = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    fleetData.launchTemplateConfigs(launchTemplateConfigs);
                    fleetData.tags(tags);
                    break block23;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("activityStatus", targetDepth)) {
                        fleetData.activityStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("createTime", targetDepth)) {
                        fleetData.createTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("fleetId", targetDepth)) {
                        fleetData.fleetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("fleetState", targetDepth)) {
                        fleetData.fleetState(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("clientToken", targetDepth)) {
                        fleetData.clientToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("excessCapacityTerminationPolicy", targetDepth)) {
                        fleetData.excessCapacityTerminationPolicy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("fulfilledCapacity", targetDepth)) {
                        fleetData.fulfilledCapacity(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("fulfilledOnDemandCapacity", targetDepth)) {
                        fleetData.fulfilledOnDemandCapacity(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("launchTemplateConfigs", targetDepth)) {
                        launchTemplateConfigs = new ArrayList<FleetLaunchTemplateConfig>();
                        continue;
                    }
                    if (context.testExpression("launchTemplateConfigs/item", targetDepth)) {
                        launchTemplateConfigs.add(FleetLaunchTemplateConfigUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("targetCapacitySpecification", targetDepth)) {
                        fleetData.targetCapacitySpecification(TargetCapacitySpecificationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("terminateInstancesWithExpiration", targetDepth)) {
                        fleetData.terminateInstancesWithExpiration(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("type", targetDepth)) {
                        fleetData.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("validFrom", targetDepth)) {
                        fleetData.validFrom(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("validUntil", targetDepth)) {
                        fleetData.validUntil(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("replaceUnhealthyInstances", targetDepth)) {
                        fleetData.replaceUnhealthyInstances(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("spotOptions", targetDepth)) {
                        fleetData.spotOptions(SpotOptionsUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("onDemandOptions", targetDepth)) {
                        fleetData.onDemandOptions(OnDemandOptionsUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("tagSet/item", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            fleetData.launchTemplateConfigs(launchTemplateConfigs);
            fleetData.tags(tags);
        }
        return (FleetData)fleetData.build();
    }

    public static FleetDataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

