/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.DhcpConfiguration;
import software.amazon.awssdk.services.ec2.model.DhcpOptions;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.DhcpConfigurationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class DhcpOptionsUnmarshaller
implements Unmarshaller<DhcpOptions, StaxUnmarshallerContext> {
    private static final DhcpOptionsUnmarshaller INSTANCE = new DhcpOptionsUnmarshaller();

    public DhcpOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        DhcpOptions.Builder dhcpOptions;
        block8: {
            dhcpOptions = DhcpOptions.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<DhcpConfiguration> dhcpConfigurations = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    dhcpOptions.dhcpConfigurations(dhcpConfigurations);
                    dhcpOptions.tags(tags);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("dhcpConfigurationSet", targetDepth)) {
                        dhcpConfigurations = new ArrayList<DhcpConfiguration>();
                        continue;
                    }
                    if (context.testExpression("dhcpConfigurationSet/item", targetDepth)) {
                        dhcpConfigurations.add(DhcpConfigurationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("dhcpOptionsId", targetDepth)) {
                        dhcpOptions.dhcpOptionsId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("tagSet/item", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            dhcpOptions.dhcpConfigurations(dhcpConfigurations);
            dhcpOptions.tags(tags);
        }
        return (DhcpOptions)dhcpOptions.build();
    }

    public static DhcpOptionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

