/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVolumesRequestMarshaller
implements Marshaller<Request<DescribeVolumesRequest>, DescribeVolumesRequest> {
    public Request<DescribeVolumesRequest> marshall(DescribeVolumesRequest describeVolumesRequest) {
        List<String> describeVolumesRequestVolumeIdsList;
        if (describeVolumesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVolumesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVolumes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeVolumesRequestFiltersList = describeVolumesRequest.filters();
        if (!describeVolumesRequestFiltersList.isEmpty() || !(describeVolumesRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeVolumesRequestFiltersListValue : describeVolumesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVolumesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeVolumesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeVolumesRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeVolumesRequestVolumeIdsList = describeVolumesRequest.volumeIds()).isEmpty() || !(describeVolumesRequestVolumeIdsList instanceof SdkAutoConstructList)) {
            int volumeIdsListIndex = 1;
            for (String describeVolumesRequestVolumeIdsListValue : describeVolumesRequestVolumeIdsList) {
                if (describeVolumesRequestVolumeIdsListValue != null) {
                    request.addParameter("VolumeId." + volumeIdsListIndex, StringConversion.fromString((String)describeVolumesRequestVolumeIdsListValue));
                }
                ++volumeIdsListIndex;
            }
        }
        if (describeVolumesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeVolumesRequest.maxResults()));
        }
        if (describeVolumesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeVolumesRequest.nextToken()));
        }
        return request;
    }
}

