/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest;

public class DescribeSecurityGroupReferencesRequestMarshaller
implements Marshaller<Request<DescribeSecurityGroupReferencesRequest>, DescribeSecurityGroupReferencesRequest> {
    public Request<DescribeSecurityGroupReferencesRequest> marshall(DescribeSecurityGroupReferencesRequest describeSecurityGroupReferencesRequest) {
        if (describeSecurityGroupReferencesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeSecurityGroupReferencesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeSecurityGroupReferences");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeSecurityGroupReferencesRequestGroupIdList = describeSecurityGroupReferencesRequest.groupId();
        if (!describeSecurityGroupReferencesRequestGroupIdList.isEmpty() || !(describeSecurityGroupReferencesRequestGroupIdList instanceof SdkAutoConstructList)) {
            int groupIdListIndex = 1;
            for (String describeSecurityGroupReferencesRequestGroupIdListValue : describeSecurityGroupReferencesRequestGroupIdList) {
                if (describeSecurityGroupReferencesRequestGroupIdListValue != null) {
                    request.addParameter("GroupId." + groupIdListIndex, StringConversion.fromString((String)describeSecurityGroupReferencesRequestGroupIdListValue));
                }
                ++groupIdListIndex;
            }
        }
        return request;
    }
}

