/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeReservedInstancesOfferingsRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesOfferingsRequest>, DescribeReservedInstancesOfferingsRequest> {
    public Request<DescribeReservedInstancesOfferingsRequest> marshall(DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) {
        List<String> describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList;
        List<Filter> describeReservedInstancesOfferingsRequestFiltersList;
        if (describeReservedInstancesOfferingsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeReservedInstancesOfferingsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeReservedInstancesOfferings");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReservedInstancesOfferingsRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)describeReservedInstancesOfferingsRequest.availabilityZone()));
        }
        if (!(describeReservedInstancesOfferingsRequestFiltersList = describeReservedInstancesOfferingsRequest.filters()).isEmpty() || !(describeReservedInstancesOfferingsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeReservedInstancesOfferingsRequestFiltersListValue : describeReservedInstancesOfferingsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeReservedInstancesOfferingsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeReservedInstancesOfferingsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeReservedInstancesOfferingsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeReservedInstancesOfferingsRequest.includeMarketplace() != null) {
            request.addParameter("IncludeMarketplace", StringConversion.fromBoolean((Boolean)describeReservedInstancesOfferingsRequest.includeMarketplace()));
        }
        if (describeReservedInstancesOfferingsRequest.instanceTypeAsString() != null) {
            request.addParameter("InstanceType", StringConversion.fromString((String)describeReservedInstancesOfferingsRequest.instanceTypeAsString()));
        }
        if (describeReservedInstancesOfferingsRequest.maxDuration() != null) {
            request.addParameter("MaxDuration", StringConversion.fromLong((Long)describeReservedInstancesOfferingsRequest.maxDuration()));
        }
        if (describeReservedInstancesOfferingsRequest.maxInstanceCount() != null) {
            request.addParameter("MaxInstanceCount", StringConversion.fromInteger((Integer)describeReservedInstancesOfferingsRequest.maxInstanceCount()));
        }
        if (describeReservedInstancesOfferingsRequest.minDuration() != null) {
            request.addParameter("MinDuration", StringConversion.fromLong((Long)describeReservedInstancesOfferingsRequest.minDuration()));
        }
        if (describeReservedInstancesOfferingsRequest.offeringClassAsString() != null) {
            request.addParameter("OfferingClass", StringConversion.fromString((String)describeReservedInstancesOfferingsRequest.offeringClassAsString()));
        }
        if (describeReservedInstancesOfferingsRequest.productDescriptionAsString() != null) {
            request.addParameter("ProductDescription", StringConversion.fromString((String)describeReservedInstancesOfferingsRequest.productDescriptionAsString()));
        }
        if (!(describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList = describeReservedInstancesOfferingsRequest.reservedInstancesOfferingIds()).isEmpty() || !(describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList instanceof SdkAutoConstructList)) {
            int reservedInstancesOfferingIdsListIndex = 1;
            for (String describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsListValue : describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList) {
                if (describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsListValue != null) {
                    request.addParameter("ReservedInstancesOfferingId." + reservedInstancesOfferingIdsListIndex, StringConversion.fromString((String)describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsListValue));
                }
                ++reservedInstancesOfferingIdsListIndex;
            }
        }
        if (describeReservedInstancesOfferingsRequest.instanceTenancyAsString() != null) {
            request.addParameter("InstanceTenancy", StringConversion.fromString((String)describeReservedInstancesOfferingsRequest.instanceTenancyAsString()));
        }
        if (describeReservedInstancesOfferingsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeReservedInstancesOfferingsRequest.maxResults()));
        }
        if (describeReservedInstancesOfferingsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeReservedInstancesOfferingsRequest.nextToken()));
        }
        if (describeReservedInstancesOfferingsRequest.offeringTypeAsString() != null) {
            request.addParameter("OfferingType", StringConversion.fromString((String)describeReservedInstancesOfferingsRequest.offeringTypeAsString()));
        }
        return request;
    }
}

