/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeReservedInstancesModificationsRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesModificationsRequest>, DescribeReservedInstancesModificationsRequest> {
    public Request<DescribeReservedInstancesModificationsRequest> marshall(DescribeReservedInstancesModificationsRequest describeReservedInstancesModificationsRequest) {
        List<String> describeReservedInstancesModificationsRequestReservedInstancesModificationIdsList;
        if (describeReservedInstancesModificationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeReservedInstancesModificationsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeReservedInstancesModifications");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeReservedInstancesModificationsRequestFiltersList = describeReservedInstancesModificationsRequest.filters();
        if (!describeReservedInstancesModificationsRequestFiltersList.isEmpty() || !(describeReservedInstancesModificationsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeReservedInstancesModificationsRequestFiltersListValue : describeReservedInstancesModificationsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeReservedInstancesModificationsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeReservedInstancesModificationsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeReservedInstancesModificationsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeReservedInstancesModificationsRequestReservedInstancesModificationIdsList = describeReservedInstancesModificationsRequest.reservedInstancesModificationIds()).isEmpty() || !(describeReservedInstancesModificationsRequestReservedInstancesModificationIdsList instanceof SdkAutoConstructList)) {
            int reservedInstancesModificationIdsListIndex = 1;
            for (String describeReservedInstancesModificationsRequestReservedInstancesModificationIdsListValue : describeReservedInstancesModificationsRequestReservedInstancesModificationIdsList) {
                if (describeReservedInstancesModificationsRequestReservedInstancesModificationIdsListValue != null) {
                    request.addParameter("ReservedInstancesModificationId." + reservedInstancesModificationIdsListIndex, StringConversion.fromString((String)describeReservedInstancesModificationsRequestReservedInstancesModificationIdsListValue));
                }
                ++reservedInstancesModificationIdsListIndex;
            }
        }
        if (describeReservedInstancesModificationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeReservedInstancesModificationsRequest.nextToken()));
        }
        return request;
    }
}

