/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeNatGatewaysRequestMarshaller
implements Marshaller<Request<DescribeNatGatewaysRequest>, DescribeNatGatewaysRequest> {
    public Request<DescribeNatGatewaysRequest> marshall(DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        List<String> describeNatGatewaysRequestNatGatewayIdsList;
        if (describeNatGatewaysRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeNatGatewaysRequest, "Ec2Client");
        request.addParameter("Action", "DescribeNatGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeNatGatewaysRequestFilterList = describeNatGatewaysRequest.filter();
        if (!describeNatGatewaysRequestFilterList.isEmpty() || !(describeNatGatewaysRequestFilterList instanceof SdkAutoConstructList)) {
            int filterListIndex = 1;
            for (Filter describeNatGatewaysRequestFilterListValue : describeNatGatewaysRequestFilterList) {
                List<String> filterValuesList;
                if (describeNatGatewaysRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringConversion.fromString((String)describeNatGatewaysRequestFilterListValue.name()));
                }
                if (!(filterValuesList = describeNatGatewaysRequestFilterListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (describeNatGatewaysRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeNatGatewaysRequest.maxResults()));
        }
        if (!(describeNatGatewaysRequestNatGatewayIdsList = describeNatGatewaysRequest.natGatewayIds()).isEmpty() || !(describeNatGatewaysRequestNatGatewayIdsList instanceof SdkAutoConstructList)) {
            int natGatewayIdsListIndex = 1;
            for (String describeNatGatewaysRequestNatGatewayIdsListValue : describeNatGatewaysRequestNatGatewayIdsList) {
                if (describeNatGatewaysRequestNatGatewayIdsListValue != null) {
                    request.addParameter("NatGatewayId." + natGatewayIdsListIndex, StringConversion.fromString((String)describeNatGatewaysRequestNatGatewayIdsListValue));
                }
                ++natGatewayIdsListIndex;
            }
        }
        if (describeNatGatewaysRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeNatGatewaysRequest.nextToken()));
        }
        return request;
    }
}

