/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeInternetGatewaysRequestMarshaller
implements Marshaller<Request<DescribeInternetGatewaysRequest>, DescribeInternetGatewaysRequest> {
    public Request<DescribeInternetGatewaysRequest> marshall(DescribeInternetGatewaysRequest describeInternetGatewaysRequest) {
        List<String> describeInternetGatewaysRequestInternetGatewayIdsList;
        if (describeInternetGatewaysRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeInternetGatewaysRequest, "Ec2Client");
        request.addParameter("Action", "DescribeInternetGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeInternetGatewaysRequestFiltersList = describeInternetGatewaysRequest.filters();
        if (!describeInternetGatewaysRequestFiltersList.isEmpty() || !(describeInternetGatewaysRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeInternetGatewaysRequestFiltersListValue : describeInternetGatewaysRequestFiltersList) {
                List<String> filterValuesList;
                if (describeInternetGatewaysRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeInternetGatewaysRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeInternetGatewaysRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeInternetGatewaysRequestInternetGatewayIdsList = describeInternetGatewaysRequest.internetGatewayIds()).isEmpty() || !(describeInternetGatewaysRequestInternetGatewayIdsList instanceof SdkAutoConstructList)) {
            int internetGatewayIdsListIndex = 1;
            for (String describeInternetGatewaysRequestInternetGatewayIdsListValue : describeInternetGatewaysRequestInternetGatewayIdsList) {
                if (describeInternetGatewaysRequestInternetGatewayIdsListValue != null) {
                    request.addParameter("InternetGatewayId." + internetGatewayIdsListIndex, StringConversion.fromString((String)describeInternetGatewaysRequestInternetGatewayIdsListValue));
                }
                ++internetGatewayIdsListIndex;
            }
        }
        return request;
    }
}

