/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest;

public class DescribeImageAttributeRequestMarshaller
implements Marshaller<Request<DescribeImageAttributeRequest>, DescribeImageAttributeRequest> {
    public Request<DescribeImageAttributeRequest> marshall(DescribeImageAttributeRequest describeImageAttributeRequest) {
        if (describeImageAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeImageAttributeRequest, "Ec2Client");
        request.addParameter("Action", "DescribeImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeImageAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringConversion.fromString((String)describeImageAttributeRequest.attributeAsString()));
        }
        if (describeImageAttributeRequest.imageId() != null) {
            request.addParameter("ImageId", StringConversion.fromString((String)describeImageAttributeRequest.imageId()));
        }
        return request;
    }
}

