/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest;

public class DeleteLaunchTemplateRequestMarshaller
implements Marshaller<Request<DeleteLaunchTemplateRequest>, DeleteLaunchTemplateRequest> {
    public Request<DeleteLaunchTemplateRequest> marshall(DeleteLaunchTemplateRequest deleteLaunchTemplateRequest) {
        if (deleteLaunchTemplateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteLaunchTemplateRequest, "Ec2Client");
        request.addParameter("Action", "DeleteLaunchTemplate");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteLaunchTemplateRequest.launchTemplateId() != null) {
            request.addParameter("LaunchTemplateId", StringConversion.fromString((String)deleteLaunchTemplateRequest.launchTemplateId()));
        }
        if (deleteLaunchTemplateRequest.launchTemplateName() != null) {
            request.addParameter("LaunchTemplateName", StringConversion.fromString((String)deleteLaunchTemplateRequest.launchTemplateName()));
        }
        return request;
    }
}

