/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DeleteFleetsRequest;

public class DeleteFleetsRequestMarshaller
implements Marshaller<Request<DeleteFleetsRequest>, DeleteFleetsRequest> {
    public Request<DeleteFleetsRequest> marshall(DeleteFleetsRequest deleteFleetsRequest) {
        if (deleteFleetsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteFleetsRequest, "Ec2Client");
        request.addParameter("Action", "DeleteFleets");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> deleteFleetsRequestFleetIdsList = deleteFleetsRequest.fleetIds();
        if (!deleteFleetsRequestFleetIdsList.isEmpty() || !(deleteFleetsRequestFleetIdsList instanceof SdkAutoConstructList)) {
            int fleetIdsListIndex = 1;
            for (String deleteFleetsRequestFleetIdsListValue : deleteFleetsRequestFleetIdsList) {
                if (deleteFleetsRequestFleetIdsListValue != null) {
                    request.addParameter("FleetId." + fleetIdsListIndex, StringConversion.fromString((String)deleteFleetsRequestFleetIdsListValue));
                }
                ++fleetIdsListIndex;
            }
        }
        if (deleteFleetsRequest.terminateInstances() != null) {
            request.addParameter("TerminateInstances", StringConversion.fromBoolean((Boolean)deleteFleetsRequest.terminateInstances()));
        }
        return request;
    }
}

