/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest;

public class CreateVpcEndpointRequestMarshaller
implements Marshaller<Request<CreateVpcEndpointRequest>, CreateVpcEndpointRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateVpcEndpointRequest> marshall(CreateVpcEndpointRequest createVpcEndpointRequest) {
        List<String> createVpcEndpointRequestSecurityGroupIdsList;
        List<String> createVpcEndpointRequestSubnetIdsList;
        List<String> createVpcEndpointRequestRouteTableIdsList;
        if (createVpcEndpointRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createVpcEndpointRequest, "Ec2Client");
        request.addParameter("Action", "CreateVpcEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcEndpointRequest.vpcEndpointTypeAsString() != null) {
            request.addParameter("VpcEndpointType", StringConversion.fromString((String)createVpcEndpointRequest.vpcEndpointTypeAsString()));
        }
        if (createVpcEndpointRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)createVpcEndpointRequest.vpcId()));
        }
        if (createVpcEndpointRequest.serviceName() != null) {
            request.addParameter("ServiceName", StringConversion.fromString((String)createVpcEndpointRequest.serviceName()));
        }
        if (createVpcEndpointRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringConversion.fromString((String)createVpcEndpointRequest.policyDocument()));
        }
        if (!(createVpcEndpointRequestRouteTableIdsList = createVpcEndpointRequest.routeTableIds()).isEmpty() || !(createVpcEndpointRequestRouteTableIdsList instanceof SdkAutoConstructList)) {
            int routeTableIdsListIndex = 1;
            for (String string : createVpcEndpointRequestRouteTableIdsList) {
                if (string != null) {
                    request.addParameter("RouteTableId." + routeTableIdsListIndex, StringConversion.fromString((String)string));
                }
                ++routeTableIdsListIndex;
            }
        }
        if (!(createVpcEndpointRequestSubnetIdsList = createVpcEndpointRequest.subnetIds()).isEmpty() || !(createVpcEndpointRequestSubnetIdsList instanceof SdkAutoConstructList)) {
            int subnetIdsListIndex = 1;
            for (String createVpcEndpointRequestSubnetIdsListValue : createVpcEndpointRequestSubnetIdsList) {
                if (createVpcEndpointRequestSubnetIdsListValue != null) {
                    request.addParameter("SubnetId." + subnetIdsListIndex, StringConversion.fromString((String)createVpcEndpointRequestSubnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        if (!(createVpcEndpointRequestSecurityGroupIdsList = createVpcEndpointRequest.securityGroupIds()).isEmpty() || !(createVpcEndpointRequestSecurityGroupIdsList instanceof SdkAutoConstructList)) {
            boolean bl = true;
            for (String createVpcEndpointRequestSecurityGroupIdsListValue : createVpcEndpointRequestSecurityGroupIdsList) {
                void var6_12;
                if (createVpcEndpointRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + (int)var6_12, StringConversion.fromString((String)createVpcEndpointRequestSecurityGroupIdsListValue));
                }
                ++var6_12;
            }
        }
        if (createVpcEndpointRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)createVpcEndpointRequest.clientToken()));
        }
        if (createVpcEndpointRequest.privateDnsEnabled() != null) {
            request.addParameter("PrivateDnsEnabled", StringConversion.fromBoolean((Boolean)createVpcEndpointRequest.privateDnsEnabled()));
        }
        return request;
    }
}

