/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.Tag;

public class CreateTagsRequestMarshaller
implements Marshaller<Request<CreateTagsRequest>, CreateTagsRequest> {
    public Request<CreateTagsRequest> marshall(CreateTagsRequest createTagsRequest) {
        List<Tag> createTagsRequestTagsList;
        if (createTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createTagsRequest, "Ec2Client");
        request.addParameter("Action", "CreateTags");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> createTagsRequestResourcesList = createTagsRequest.resources();
        if (!createTagsRequestResourcesList.isEmpty() || !(createTagsRequestResourcesList instanceof SdkAutoConstructList)) {
            int resourcesListIndex = 1;
            for (String createTagsRequestResourcesListValue : createTagsRequestResourcesList) {
                if (createTagsRequestResourcesListValue != null) {
                    request.addParameter("ResourceId." + resourcesListIndex, StringConversion.fromString((String)createTagsRequestResourcesListValue));
                }
                ++resourcesListIndex;
            }
        }
        if (!(createTagsRequestTagsList = createTagsRequest.tags()).isEmpty() || !(createTagsRequestTagsList instanceof SdkAutoConstructList)) {
            int tagsListIndex = 1;
            for (Tag createTagsRequestTagsListValue : createTagsRequestTagsList) {
                if (createTagsRequestTagsListValue.key() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)createTagsRequestTagsListValue.key()));
                }
                if (createTagsRequestTagsListValue.value() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)createTagsRequestTagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

