/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagSpecification;

public class CreateSnapshotRequestMarshaller
implements Marshaller<Request<CreateSnapshotRequest>, CreateSnapshotRequest> {
    public Request<CreateSnapshotRequest> marshall(CreateSnapshotRequest createSnapshotRequest) {
        List<TagSpecification> createSnapshotRequestTagSpecificationsList;
        if (createSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createSnapshotRequest, "Ec2Client");
        request.addParameter("Action", "CreateSnapshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSnapshotRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createSnapshotRequest.description()));
        }
        if (createSnapshotRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringConversion.fromString((String)createSnapshotRequest.volumeId()));
        }
        if (!(createSnapshotRequestTagSpecificationsList = createSnapshotRequest.tagSpecifications()).isEmpty() || !(createSnapshotRequestTagSpecificationsList instanceof SdkAutoConstructList)) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createSnapshotRequestTagSpecificationsListValue : createSnapshotRequestTagSpecificationsList) {
                List<Tag> tagSpecificationTagsList;
                if (createSnapshotRequestTagSpecificationsListValue.resourceTypeAsString() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringConversion.fromString((String)createSnapshotRequestTagSpecificationsListValue.resourceTypeAsString()));
                }
                if (!(tagSpecificationTagsList = createSnapshotRequestTagSpecificationsListValue.tags()).isEmpty() || !(tagSpecificationTagsList instanceof SdkAutoConstructList)) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.key() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagSpecificationTagsListValue.key()));
                        }
                        if (tagSpecificationTagsListValue.value() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagSpecificationTagsListValue.value()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

