/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateRouteRequest;

public class CreateRouteRequestMarshaller
implements Marshaller<Request<CreateRouteRequest>, CreateRouteRequest> {
    public Request<CreateRouteRequest> marshall(CreateRouteRequest createRouteRequest) {
        if (createRouteRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createRouteRequest, "Ec2Client");
        request.addParameter("Action", "CreateRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRouteRequest.destinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringConversion.fromString((String)createRouteRequest.destinationCidrBlock()));
        }
        if (createRouteRequest.destinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock", StringConversion.fromString((String)createRouteRequest.destinationIpv6CidrBlock()));
        }
        if (createRouteRequest.egressOnlyInternetGatewayId() != null) {
            request.addParameter("EgressOnlyInternetGatewayId", StringConversion.fromString((String)createRouteRequest.egressOnlyInternetGatewayId()));
        }
        if (createRouteRequest.gatewayId() != null) {
            request.addParameter("GatewayId", StringConversion.fromString((String)createRouteRequest.gatewayId()));
        }
        if (createRouteRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)createRouteRequest.instanceId()));
        }
        if (createRouteRequest.natGatewayId() != null) {
            request.addParameter("NatGatewayId", StringConversion.fromString((String)createRouteRequest.natGatewayId()));
        }
        if (createRouteRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringConversion.fromString((String)createRouteRequest.networkInterfaceId()));
        }
        if (createRouteRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringConversion.fromString((String)createRouteRequest.routeTableId()));
        }
        if (createRouteRequest.vpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringConversion.fromString((String)createRouteRequest.vpcPeeringConnectionId()));
        }
        return request;
    }
}

