/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest;

public class CreateNatGatewayRequestMarshaller
implements Marshaller<Request<CreateNatGatewayRequest>, CreateNatGatewayRequest> {
    public Request<CreateNatGatewayRequest> marshall(CreateNatGatewayRequest createNatGatewayRequest) {
        if (createNatGatewayRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createNatGatewayRequest, "Ec2Client");
        request.addParameter("Action", "CreateNatGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNatGatewayRequest.allocationId() != null) {
            request.addParameter("AllocationId", StringConversion.fromString((String)createNatGatewayRequest.allocationId()));
        }
        if (createNatGatewayRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)createNatGatewayRequest.clientToken()));
        }
        if (createNatGatewayRequest.subnetId() != null) {
            request.addParameter("SubnetId", StringConversion.fromString((String)createNatGatewayRequest.subnetId()));
        }
        return request;
    }
}

