/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateFleetRequest;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverridesRequest;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.OnDemandOptionsRequest;
import software.amazon.awssdk.services.ec2.model.SpotOptionsRequest;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TargetCapacitySpecificationRequest;

public class CreateFleetRequestMarshaller
implements Marshaller<Request<CreateFleetRequest>, CreateFleetRequest> {
    public Request<CreateFleetRequest> marshall(CreateFleetRequest createFleetRequest) {
        List<TagSpecification> createFleetRequestTagSpecificationsList;
        TargetCapacitySpecificationRequest targetCapacitySpecification;
        List<FleetLaunchTemplateConfigRequest> createFleetRequestLaunchTemplateConfigsList;
        OnDemandOptionsRequest onDemandOptions;
        SpotOptionsRequest spotOptions;
        if (createFleetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createFleetRequest, "Ec2Client");
        request.addParameter("Action", "CreateFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createFleetRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)createFleetRequest.clientToken()));
        }
        if ((spotOptions = createFleetRequest.spotOptions()) != null) {
            if (spotOptions.allocationStrategyAsString() != null) {
                request.addParameter("SpotOptions.AllocationStrategy", StringConversion.fromString((String)spotOptions.allocationStrategyAsString()));
            }
            if (spotOptions.instanceInterruptionBehaviorAsString() != null) {
                request.addParameter("SpotOptions.InstanceInterruptionBehavior", StringConversion.fromString((String)spotOptions.instanceInterruptionBehaviorAsString()));
            }
            if (spotOptions.instancePoolsToUseCount() != null) {
                request.addParameter("SpotOptions.InstancePoolsToUseCount", StringConversion.fromInteger((Integer)spotOptions.instancePoolsToUseCount()));
            }
        }
        if ((onDemandOptions = createFleetRequest.onDemandOptions()) != null && onDemandOptions.allocationStrategyAsString() != null) {
            request.addParameter("OnDemandOptions.AllocationStrategy", StringConversion.fromString((String)onDemandOptions.allocationStrategyAsString()));
        }
        if (createFleetRequest.excessCapacityTerminationPolicyAsString() != null) {
            request.addParameter("ExcessCapacityTerminationPolicy", StringConversion.fromString((String)createFleetRequest.excessCapacityTerminationPolicyAsString()));
        }
        if (!(createFleetRequestLaunchTemplateConfigsList = createFleetRequest.launchTemplateConfigs()).isEmpty() || !(createFleetRequestLaunchTemplateConfigsList instanceof SdkAutoConstructList)) {
            int launchTemplateConfigsListIndex = 1;
            for (FleetLaunchTemplateConfigRequest createFleetRequestLaunchTemplateConfigsListValue : createFleetRequestLaunchTemplateConfigsList) {
                List<FleetLaunchTemplateOverridesRequest> fleetLaunchTemplateConfigRequestOverridesList;
                FleetLaunchTemplateSpecificationRequest launchTemplateSpecification = createFleetRequestLaunchTemplateConfigsListValue.launchTemplateSpecification();
                if (launchTemplateSpecification != null) {
                    if (launchTemplateSpecification.launchTemplateId() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringConversion.fromString((String)launchTemplateSpecification.launchTemplateId()));
                    }
                    if (launchTemplateSpecification.launchTemplateName() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringConversion.fromString((String)launchTemplateSpecification.launchTemplateName()));
                    }
                    if (launchTemplateSpecification.version() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.Version", StringConversion.fromString((String)launchTemplateSpecification.version()));
                    }
                }
                if (!(fleetLaunchTemplateConfigRequestOverridesList = createFleetRequestLaunchTemplateConfigsListValue.overrides()).isEmpty() || !(fleetLaunchTemplateConfigRequestOverridesList instanceof SdkAutoConstructList)) {
                    int overridesListIndex = 1;
                    for (FleetLaunchTemplateOverridesRequest fleetLaunchTemplateConfigRequestOverridesListValue : fleetLaunchTemplateConfigRequestOverridesList) {
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.instanceTypeAsString() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceType", StringConversion.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.instanceTypeAsString()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.maxPrice() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".MaxPrice", StringConversion.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.maxPrice()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.subnetId() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SubnetId", StringConversion.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.subnetId()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.availabilityZone() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".AvailabilityZone", StringConversion.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.availabilityZone()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.weightedCapacity() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".WeightedCapacity", StringConversion.fromDouble((Double)fleetLaunchTemplateConfigRequestOverridesListValue.weightedCapacity()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.priority() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Priority", StringConversion.fromDouble((Double)fleetLaunchTemplateConfigRequestOverridesListValue.priority()));
                        }
                        ++overridesListIndex;
                    }
                }
                ++launchTemplateConfigsListIndex;
            }
        }
        if ((targetCapacitySpecification = createFleetRequest.targetCapacitySpecification()) != null) {
            if (targetCapacitySpecification.totalTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.TotalTargetCapacity", StringConversion.fromInteger((Integer)targetCapacitySpecification.totalTargetCapacity()));
            }
            if (targetCapacitySpecification.onDemandTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.OnDemandTargetCapacity", StringConversion.fromInteger((Integer)targetCapacitySpecification.onDemandTargetCapacity()));
            }
            if (targetCapacitySpecification.spotTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.SpotTargetCapacity", StringConversion.fromInteger((Integer)targetCapacitySpecification.spotTargetCapacity()));
            }
            if (targetCapacitySpecification.defaultTargetCapacityTypeAsString() != null) {
                request.addParameter("TargetCapacitySpecification.DefaultTargetCapacityType", StringConversion.fromString((String)targetCapacitySpecification.defaultTargetCapacityTypeAsString()));
            }
        }
        if (createFleetRequest.terminateInstancesWithExpiration() != null) {
            request.addParameter("TerminateInstancesWithExpiration", StringConversion.fromBoolean((Boolean)createFleetRequest.terminateInstancesWithExpiration()));
        }
        if (createFleetRequest.typeAsString() != null) {
            request.addParameter("Type", StringConversion.fromString((String)createFleetRequest.typeAsString()));
        }
        if (createFleetRequest.validFrom() != null) {
            request.addParameter("ValidFrom", StringConversion.fromInstant((Instant)createFleetRequest.validFrom()));
        }
        if (createFleetRequest.validUntil() != null) {
            request.addParameter("ValidUntil", StringConversion.fromInstant((Instant)createFleetRequest.validUntil()));
        }
        if (createFleetRequest.replaceUnhealthyInstances() != null) {
            request.addParameter("ReplaceUnhealthyInstances", StringConversion.fromBoolean((Boolean)createFleetRequest.replaceUnhealthyInstances()));
        }
        if (!(createFleetRequestTagSpecificationsList = createFleetRequest.tagSpecifications()).isEmpty() || !(createFleetRequestTagSpecificationsList instanceof SdkAutoConstructList)) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createFleetRequestTagSpecificationsListValue : createFleetRequestTagSpecificationsList) {
                List<Tag> tagSpecificationTagsList;
                if (createFleetRequestTagSpecificationsListValue.resourceTypeAsString() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringConversion.fromString((String)createFleetRequestTagSpecificationsListValue.resourceTypeAsString()));
                }
                if (!(tagSpecificationTagsList = createFleetRequestTagSpecificationsListValue.tags()).isEmpty() || !(tagSpecificationTagsList instanceof SdkAutoConstructList)) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.key() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagSpecificationTagsListValue.key()));
                        }
                        if (tagSpecificationTagsListValue.value() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagSpecificationTagsListValue.value()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

