/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest;

public class CreateCustomerGatewayRequestMarshaller
implements Marshaller<Request<CreateCustomerGatewayRequest>, CreateCustomerGatewayRequest> {
    public Request<CreateCustomerGatewayRequest> marshall(CreateCustomerGatewayRequest createCustomerGatewayRequest) {
        if (createCustomerGatewayRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createCustomerGatewayRequest, "Ec2Client");
        request.addParameter("Action", "CreateCustomerGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCustomerGatewayRequest.bgpAsn() != null) {
            request.addParameter("BgpAsn", StringConversion.fromInteger((Integer)createCustomerGatewayRequest.bgpAsn()));
        }
        if (createCustomerGatewayRequest.publicIp() != null) {
            request.addParameter("IpAddress", StringConversion.fromString((String)createCustomerGatewayRequest.publicIp()));
        }
        if (createCustomerGatewayRequest.typeAsString() != null) {
            request.addParameter("Type", StringConversion.fromString((String)createCustomerGatewayRequest.typeAsString()));
        }
        return request;
    }
}

