/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.CpuOptionsRequest;

public class CpuOptionsRequestUnmarshaller
implements Unmarshaller<CpuOptionsRequest, StaxUnmarshallerContext> {
    private static final CpuOptionsRequestUnmarshaller INSTANCE = new CpuOptionsRequestUnmarshaller();

    public CpuOptionsRequest unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CpuOptionsRequest.Builder cpuOptionsRequest = CpuOptionsRequest.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CoreCount", targetDepth)) {
                    cpuOptionsRequest.coreCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ThreadsPerCore", targetDepth)) continue;
                cpuOptionsRequest.threadsPerCore(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CpuOptionsRequest)cpuOptionsRequest.build();
    }

    public static CpuOptionsRequestUnmarshaller getInstance() {
        return INSTANCE;
    }
}

