/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;

public class AssociateIamInstanceProfileRequestMarshaller
implements Marshaller<Request<AssociateIamInstanceProfileRequest>, AssociateIamInstanceProfileRequest> {
    public Request<AssociateIamInstanceProfileRequest> marshall(AssociateIamInstanceProfileRequest associateIamInstanceProfileRequest) {
        if (associateIamInstanceProfileRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)associateIamInstanceProfileRequest, "Ec2Client");
        request.addParameter("Action", "AssociateIamInstanceProfile");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        IamInstanceProfileSpecification iamInstanceProfile = associateIamInstanceProfileRequest.iamInstanceProfile();
        if (iamInstanceProfile != null) {
            if (iamInstanceProfile.arn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringConversion.fromString((String)iamInstanceProfile.arn()));
            }
            if (iamInstanceProfile.name() != null) {
                request.addParameter("IamInstanceProfile.Name", StringConversion.fromString((String)iamInstanceProfile.name()));
            }
        }
        if (associateIamInstanceProfileRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)associateIamInstanceProfileRequest.instanceId()));
        }
        return request;
    }
}

