/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.State;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcEndpointConnection
implements ToCopyableBuilder<Builder, VpcEndpointConnection> {
    private final String serviceId;
    private final String vpcEndpointId;
    private final String vpcEndpointOwner;
    private final String vpcEndpointState;
    private final Instant creationTimestamp;

    private VpcEndpointConnection(BuilderImpl builder) {
        this.serviceId = builder.serviceId;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcEndpointOwner = builder.vpcEndpointOwner;
        this.vpcEndpointState = builder.vpcEndpointState;
        this.creationTimestamp = builder.creationTimestamp;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public String vpcEndpointOwner() {
        return this.vpcEndpointOwner;
    }

    public State vpcEndpointState() {
        return State.fromValue(this.vpcEndpointState);
    }

    public String vpcEndpointStateAsString() {
        return this.vpcEndpointState;
    }

    public Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpointConnection)) {
            return false;
        }
        VpcEndpointConnection other = (VpcEndpointConnection)obj;
        return Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.vpcEndpointOwner(), other.vpcEndpointOwner()) && Objects.equals(this.vpcEndpointStateAsString(), other.vpcEndpointStateAsString()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"VpcEndpointConnection").add("ServiceId", (Object)this.serviceId()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("VpcEndpointOwner", (Object)this.vpcEndpointOwner()).add("VpcEndpointState", (Object)this.vpcEndpointStateAsString()).add("CreationTimestamp", (Object)this.creationTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "VpcEndpointOwner": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointOwner()));
            }
            case "VpcEndpointState": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointStateAsString()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceId;
        private String vpcEndpointId;
        private String vpcEndpointOwner;
        private String vpcEndpointState;
        private Instant creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpointConnection model) {
            this.serviceId(model.serviceId);
            this.vpcEndpointId(model.vpcEndpointId);
            this.vpcEndpointOwner(model.vpcEndpointOwner);
            this.vpcEndpointState(model.vpcEndpointState);
            this.creationTimestamp(model.creationTimestamp);
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final String getVpcEndpointOwner() {
            return this.vpcEndpointOwner;
        }

        @Override
        public final Builder vpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
            return this;
        }

        public final void setVpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
        }

        public final String getVpcEndpointState() {
            return this.vpcEndpointState;
        }

        @Override
        public final Builder vpcEndpointState(String vpcEndpointState) {
            this.vpcEndpointState = vpcEndpointState;
            return this;
        }

        @Override
        public final Builder vpcEndpointState(State vpcEndpointState) {
            this.vpcEndpointState(vpcEndpointState.toString());
            return this;
        }

        public final void setVpcEndpointState(String vpcEndpointState) {
            this.vpcEndpointState = vpcEndpointState;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public VpcEndpointConnection build() {
            return new VpcEndpointConnection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcEndpointConnection> {
        public Builder serviceId(String var1);

        public Builder vpcEndpointId(String var1);

        public Builder vpcEndpointOwner(String var1);

        public Builder vpcEndpointState(String var1);

        public Builder vpcEndpointState(State var1);

        public Builder creationTimestamp(Instant var1);
    }
}

