/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrence;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledInstance
implements ToCopyableBuilder<Builder, ScheduledInstance> {
    private final String availabilityZone;
    private final Instant createDate;
    private final String hourlyPrice;
    private final Integer instanceCount;
    private final String instanceType;
    private final String networkPlatform;
    private final Instant nextSlotStartTime;
    private final String platform;
    private final Instant previousSlotEndTime;
    private final ScheduledInstanceRecurrence recurrence;
    private final String scheduledInstanceId;
    private final Integer slotDurationInHours;
    private final Instant termEndDate;
    private final Instant termStartDate;
    private final Integer totalScheduledInstanceHours;

    private ScheduledInstance(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.createDate = builder.createDate;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.networkPlatform = builder.networkPlatform;
        this.nextSlotStartTime = builder.nextSlotStartTime;
        this.platform = builder.platform;
        this.previousSlotEndTime = builder.previousSlotEndTime;
        this.recurrence = builder.recurrence;
        this.scheduledInstanceId = builder.scheduledInstanceId;
        this.slotDurationInHours = builder.slotDurationInHours;
        this.termEndDate = builder.termEndDate;
        this.termStartDate = builder.termStartDate;
        this.totalScheduledInstanceHours = builder.totalScheduledInstanceHours;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public String hourlyPrice() {
        return this.hourlyPrice;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String networkPlatform() {
        return this.networkPlatform;
    }

    public Instant nextSlotStartTime() {
        return this.nextSlotStartTime;
    }

    public String platform() {
        return this.platform;
    }

    public Instant previousSlotEndTime() {
        return this.previousSlotEndTime;
    }

    public ScheduledInstanceRecurrence recurrence() {
        return this.recurrence;
    }

    public String scheduledInstanceId() {
        return this.scheduledInstanceId;
    }

    public Integer slotDurationInHours() {
        return this.slotDurationInHours;
    }

    public Instant termEndDate() {
        return this.termEndDate;
    }

    public Instant termStartDate() {
        return this.termStartDate;
    }

    public Integer totalScheduledInstanceHours() {
        return this.totalScheduledInstanceHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextSlotStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousSlotEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.termEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.termStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalScheduledInstanceHours());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstance)) {
            return false;
        }
        ScheduledInstance other = (ScheduledInstance)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.hourlyPrice(), other.hourlyPrice()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.networkPlatform(), other.networkPlatform()) && Objects.equals(this.nextSlotStartTime(), other.nextSlotStartTime()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.previousSlotEndTime(), other.previousSlotEndTime()) && Objects.equals(this.recurrence(), other.recurrence()) && Objects.equals(this.scheduledInstanceId(), other.scheduledInstanceId()) && Objects.equals(this.slotDurationInHours(), other.slotDurationInHours()) && Objects.equals(this.termEndDate(), other.termEndDate()) && Objects.equals(this.termStartDate(), other.termStartDate()) && Objects.equals(this.totalScheduledInstanceHours(), other.totalScheduledInstanceHours());
    }

    public String toString() {
        return ToString.builder((String)"ScheduledInstance").add("AvailabilityZone", (Object)this.availabilityZone()).add("CreateDate", (Object)this.createDate()).add("HourlyPrice", (Object)this.hourlyPrice()).add("InstanceCount", (Object)this.instanceCount()).add("InstanceType", (Object)this.instanceType()).add("NetworkPlatform", (Object)this.networkPlatform()).add("NextSlotStartTime", (Object)this.nextSlotStartTime()).add("Platform", (Object)this.platform()).add("PreviousSlotEndTime", (Object)this.previousSlotEndTime()).add("Recurrence", (Object)this.recurrence()).add("ScheduledInstanceId", (Object)this.scheduledInstanceId()).add("SlotDurationInHours", (Object)this.slotDurationInHours()).add("TermEndDate", (Object)this.termEndDate()).add("TermStartDate", (Object)this.termStartDate()).add("TotalScheduledInstanceHours", (Object)this.totalScheduledInstanceHours()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "HourlyPrice": {
                return Optional.ofNullable(clazz.cast(this.hourlyPrice()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "NetworkPlatform": {
                return Optional.ofNullable(clazz.cast(this.networkPlatform()));
            }
            case "NextSlotStartTime": {
                return Optional.ofNullable(clazz.cast(this.nextSlotStartTime()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "PreviousSlotEndTime": {
                return Optional.ofNullable(clazz.cast(this.previousSlotEndTime()));
            }
            case "Recurrence": {
                return Optional.ofNullable(clazz.cast(this.recurrence()));
            }
            case "ScheduledInstanceId": {
                return Optional.ofNullable(clazz.cast(this.scheduledInstanceId()));
            }
            case "SlotDurationInHours": {
                return Optional.ofNullable(clazz.cast(this.slotDurationInHours()));
            }
            case "TermEndDate": {
                return Optional.ofNullable(clazz.cast(this.termEndDate()));
            }
            case "TermStartDate": {
                return Optional.ofNullable(clazz.cast(this.termStartDate()));
            }
            case "TotalScheduledInstanceHours": {
                return Optional.ofNullable(clazz.cast(this.totalScheduledInstanceHours()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Instant createDate;
        private String hourlyPrice;
        private Integer instanceCount;
        private String instanceType;
        private String networkPlatform;
        private Instant nextSlotStartTime;
        private String platform;
        private Instant previousSlotEndTime;
        private ScheduledInstanceRecurrence recurrence;
        private String scheduledInstanceId;
        private Integer slotDurationInHours;
        private Instant termEndDate;
        private Instant termStartDate;
        private Integer totalScheduledInstanceHours;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstance model) {
            this.availabilityZone(model.availabilityZone);
            this.createDate(model.createDate);
            this.hourlyPrice(model.hourlyPrice);
            this.instanceCount(model.instanceCount);
            this.instanceType(model.instanceType);
            this.networkPlatform(model.networkPlatform);
            this.nextSlotStartTime(model.nextSlotStartTime);
            this.platform(model.platform);
            this.previousSlotEndTime(model.previousSlotEndTime);
            this.recurrence(model.recurrence);
            this.scheduledInstanceId(model.scheduledInstanceId);
            this.slotDurationInHours(model.slotDurationInHours);
            this.termEndDate(model.termEndDate);
            this.termStartDate(model.termStartDate);
            this.totalScheduledInstanceHours(model.totalScheduledInstanceHours);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getNetworkPlatform() {
            return this.networkPlatform;
        }

        @Override
        public final Builder networkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
            return this;
        }

        public final void setNetworkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
        }

        public final Instant getNextSlotStartTime() {
            return this.nextSlotStartTime;
        }

        @Override
        public final Builder nextSlotStartTime(Instant nextSlotStartTime) {
            this.nextSlotStartTime = nextSlotStartTime;
            return this;
        }

        public final void setNextSlotStartTime(Instant nextSlotStartTime) {
            this.nextSlotStartTime = nextSlotStartTime;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Instant getPreviousSlotEndTime() {
            return this.previousSlotEndTime;
        }

        @Override
        public final Builder previousSlotEndTime(Instant previousSlotEndTime) {
            this.previousSlotEndTime = previousSlotEndTime;
            return this;
        }

        public final void setPreviousSlotEndTime(Instant previousSlotEndTime) {
            this.previousSlotEndTime = previousSlotEndTime;
        }

        public final ScheduledInstanceRecurrence.Builder getRecurrence() {
            return this.recurrence != null ? this.recurrence.toBuilder() : null;
        }

        @Override
        public final Builder recurrence(ScheduledInstanceRecurrence recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(ScheduledInstanceRecurrence.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        public final String getScheduledInstanceId() {
            return this.scheduledInstanceId;
        }

        @Override
        public final Builder scheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
            return this;
        }

        public final void setScheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
        }

        public final Integer getSlotDurationInHours() {
            return this.slotDurationInHours;
        }

        @Override
        public final Builder slotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
            return this;
        }

        public final void setSlotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
        }

        public final Instant getTermEndDate() {
            return this.termEndDate;
        }

        @Override
        public final Builder termEndDate(Instant termEndDate) {
            this.termEndDate = termEndDate;
            return this;
        }

        public final void setTermEndDate(Instant termEndDate) {
            this.termEndDate = termEndDate;
        }

        public final Instant getTermStartDate() {
            return this.termStartDate;
        }

        @Override
        public final Builder termStartDate(Instant termStartDate) {
            this.termStartDate = termStartDate;
            return this;
        }

        public final void setTermStartDate(Instant termStartDate) {
            this.termStartDate = termStartDate;
        }

        public final Integer getTotalScheduledInstanceHours() {
            return this.totalScheduledInstanceHours;
        }

        @Override
        public final Builder totalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
            return this;
        }

        public final void setTotalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
        }

        public ScheduledInstance build() {
            return new ScheduledInstance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduledInstance> {
        public Builder availabilityZone(String var1);

        public Builder createDate(Instant var1);

        public Builder hourlyPrice(String var1);

        public Builder instanceCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder networkPlatform(String var1);

        public Builder nextSlotStartTime(Instant var1);

        public Builder platform(String var1);

        public Builder previousSlotEndTime(Instant var1);

        public Builder recurrence(ScheduledInstanceRecurrence var1);

        default public Builder recurrence(Consumer<ScheduledInstanceRecurrence.Builder> recurrence) {
            return this.recurrence((ScheduledInstanceRecurrence)((ScheduledInstanceRecurrence.Builder)ScheduledInstanceRecurrence.builder().applyMutation(recurrence)).build());
        }

        public Builder scheduledInstanceId(String var1);

        public Builder slotDurationInHours(Integer var1);

        public Builder termEndDate(Instant var1);

        public Builder termStartDate(Instant var1);

        public Builder totalScheduledInstanceHours(Integer var1);
    }
}

