/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.GroupNameStringListCopier;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Reservation
implements ToCopyableBuilder<Builder, Reservation> {
    private final List<GroupIdentifier> groups;
    private final List<Instance> instances;
    private final String ownerId;
    private final String requesterId;
    private final String reservationId;
    private final List<String> groupNames;

    private Reservation(BuilderImpl builder) {
        this.groups = builder.groups;
        this.instances = builder.instances;
        this.ownerId = builder.ownerId;
        this.requesterId = builder.requesterId;
        this.reservationId = builder.reservationId;
        this.groupNames = builder.groupNames;
    }

    public List<GroupIdentifier> groups() {
        return this.groups;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String requesterId() {
        return this.requesterId;
    }

    public String reservationId() {
        return this.reservationId;
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation)obj;
        return Objects.equals(this.groups(), other.groups()) && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.requesterId(), other.requesterId()) && Objects.equals(this.reservationId(), other.reservationId()) && Objects.equals(this.groupNames(), other.groupNames());
    }

    public String toString() {
        return ToString.builder((String)"Reservation").add("Groups", this.groups()).add("Instances", this.instances()).add("OwnerId", (Object)this.ownerId()).add("RequesterId", (Object)this.requesterId()).add("ReservationId", (Object)this.reservationId()).add("GroupNames", this.groupNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "RequesterId": {
                return Optional.ofNullable(clazz.cast(this.requesterId()));
            }
            case "ReservationId": {
                return Optional.ofNullable(clazz.cast(this.reservationId()));
            }
            case "GroupNames": {
                return Optional.ofNullable(clazz.cast(this.groupNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<GroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();
        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();
        private String ownerId;
        private String requesterId;
        private String reservationId;
        private List<String> groupNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Reservation model) {
            this.groups(model.groups);
            this.instances(model.instances);
            this.ownerId(model.ownerId);
            this.requesterId(model.requesterId);
            this.reservationId(model.reservationId);
            this.groupNames(model.groupNames);
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final Collection<Instance.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (Instance)((Instance.Builder)Instance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstanceListCopier.copyFromBuilder(instances);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getRequesterId() {
            return this.requesterId;
        }

        @Override
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        public final String getReservationId() {
            return this.reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        public final Collection<String> getGroupNames() {
            return this.groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String ... groupNames) {
            this.groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        public Reservation build() {
            return new Reservation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Reservation> {
        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder groups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder instances(Consumer<Instance.Builder> ... var1);

        public Builder ownerId(String var1);

        public Builder requesterId(String var1);

        public Builder reservationId(String var1);

        public Builder groupNames(Collection<String> var1);

        public Builder groupNames(String ... var1);
    }
}

