/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.RecurringChargeFrequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecurringCharge
implements ToCopyableBuilder<Builder, RecurringCharge> {
    private final Double amount;
    private final String frequency;

    private RecurringCharge(BuilderImpl builder) {
        this.amount = builder.amount;
        this.frequency = builder.frequency;
    }

    public Double amount() {
        return this.amount;
    }

    public RecurringChargeFrequency frequency() {
        return RecurringChargeFrequency.fromValue(this.frequency);
    }

    public String frequencyAsString() {
        return this.frequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringCharge)) {
            return false;
        }
        RecurringCharge other = (RecurringCharge)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString());
    }

    public String toString() {
        return ToString.builder((String)"RecurringCharge").add("Amount", (Object)this.amount()).add("Frequency", (Object)this.frequencyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "Frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Double amount;
        private String frequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringCharge model) {
            this.amount(model.amount);
            this.frequency(model.frequency);
        }

        public final Double getAmount() {
            return this.amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(RecurringChargeFrequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public RecurringCharge build() {
            return new RecurringCharge(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecurringCharge> {
        public Builder amount(Double var1);

        public Builder frequency(String var1);

        public Builder frequency(RecurringChargeFrequency var1);
    }
}

