/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.NatGatewayAddress;
import software.amazon.awssdk.services.ec2.model.NatGatewayAddressListCopier;
import software.amazon.awssdk.services.ec2.model.NatGatewayState;
import software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NatGateway
implements ToCopyableBuilder<Builder, NatGateway> {
    private final Instant createTime;
    private final Instant deleteTime;
    private final String failureCode;
    private final String failureMessage;
    private final List<NatGatewayAddress> natGatewayAddresses;
    private final String natGatewayId;
    private final ProvisionedBandwidth provisionedBandwidth;
    private final String state;
    private final String subnetId;
    private final String vpcId;
    private final List<Tag> tags;

    private NatGateway(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.deleteTime = builder.deleteTime;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
        this.natGatewayAddresses = builder.natGatewayAddresses;
        this.natGatewayId = builder.natGatewayId;
        this.provisionedBandwidth = builder.provisionedBandwidth;
        this.state = builder.state;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.tags = builder.tags;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Instant deleteTime() {
        return this.deleteTime;
    }

    public String failureCode() {
        return this.failureCode;
    }

    public String failureMessage() {
        return this.failureMessage;
    }

    public List<NatGatewayAddress> natGatewayAddresses() {
        return this.natGatewayAddresses;
    }

    public String natGatewayId() {
        return this.natGatewayId;
    }

    public ProvisionedBandwidth provisionedBandwidth() {
        return this.provisionedBandwidth;
    }

    public NatGatewayState state() {
        return NatGatewayState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedBandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NatGateway)) {
            return false;
        }
        NatGateway other = (NatGateway)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.deleteTime(), other.deleteTime()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.natGatewayAddresses(), other.natGatewayAddresses()) && Objects.equals(this.natGatewayId(), other.natGatewayId()) && Objects.equals(this.provisionedBandwidth(), other.provisionedBandwidth()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"NatGateway").add("CreateTime", (Object)this.createTime()).add("DeleteTime", (Object)this.deleteTime()).add("FailureCode", (Object)this.failureCode()).add("FailureMessage", (Object)this.failureMessage()).add("NatGatewayAddresses", this.natGatewayAddresses()).add("NatGatewayId", (Object)this.natGatewayId()).add("ProvisionedBandwidth", (Object)this.provisionedBandwidth()).add("State", (Object)this.stateAsString()).add("SubnetId", (Object)this.subnetId()).add("VpcId", (Object)this.vpcId()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "DeleteTime": {
                return Optional.ofNullable(clazz.cast(this.deleteTime()));
            }
            case "FailureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "NatGatewayAddresses": {
                return Optional.ofNullable(clazz.cast(this.natGatewayAddresses()));
            }
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
            case "ProvisionedBandwidth": {
                return Optional.ofNullable(clazz.cast(this.provisionedBandwidth()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant deleteTime;
        private String failureCode;
        private String failureMessage;
        private List<NatGatewayAddress> natGatewayAddresses = DefaultSdkAutoConstructList.getInstance();
        private String natGatewayId;
        private ProvisionedBandwidth provisionedBandwidth;
        private String state;
        private String subnetId;
        private String vpcId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NatGateway model) {
            this.createTime(model.createTime);
            this.deleteTime(model.deleteTime);
            this.failureCode(model.failureCode);
            this.failureMessage(model.failureMessage);
            this.natGatewayAddresses(model.natGatewayAddresses);
            this.natGatewayId(model.natGatewayId);
            this.provisionedBandwidth(model.provisionedBandwidth);
            this.state(model.state);
            this.subnetId(model.subnetId);
            this.vpcId(model.vpcId);
            this.tags(model.tags);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getDeleteTime() {
            return this.deleteTime;
        }

        @Override
        public final Builder deleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
            return this;
        }

        public final void setDeleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public final Collection<NatGatewayAddress.Builder> getNatGatewayAddresses() {
            return this.natGatewayAddresses != null ? (Collection)this.natGatewayAddresses.stream().map(NatGatewayAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder natGatewayAddresses(Collection<NatGatewayAddress> natGatewayAddresses) {
            this.natGatewayAddresses = NatGatewayAddressListCopier.copy(natGatewayAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGatewayAddresses(NatGatewayAddress ... natGatewayAddresses) {
            this.natGatewayAddresses(Arrays.asList(natGatewayAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGatewayAddresses(Consumer<NatGatewayAddress.Builder> ... natGatewayAddresses) {
            this.natGatewayAddresses(Stream.of(natGatewayAddresses).map(c -> (NatGatewayAddress)((NatGatewayAddress.Builder)NatGatewayAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNatGatewayAddresses(Collection<NatGatewayAddress.BuilderImpl> natGatewayAddresses) {
            this.natGatewayAddresses = NatGatewayAddressListCopier.copyFromBuilder(natGatewayAddresses);
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        public final ProvisionedBandwidth.Builder getProvisionedBandwidth() {
            return this.provisionedBandwidth != null ? this.provisionedBandwidth.toBuilder() : null;
        }

        @Override
        public final Builder provisionedBandwidth(ProvisionedBandwidth provisionedBandwidth) {
            this.provisionedBandwidth = provisionedBandwidth;
            return this;
        }

        public final void setProvisionedBandwidth(ProvisionedBandwidth.BuilderImpl provisionedBandwidth) {
            this.provisionedBandwidth = provisionedBandwidth != null ? provisionedBandwidth.build() : null;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(NatGatewayState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public NatGateway build() {
            return new NatGateway(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NatGateway> {
        public Builder createTime(Instant var1);

        public Builder deleteTime(Instant var1);

        public Builder failureCode(String var1);

        public Builder failureMessage(String var1);

        public Builder natGatewayAddresses(Collection<NatGatewayAddress> var1);

        public Builder natGatewayAddresses(NatGatewayAddress ... var1);

        public Builder natGatewayAddresses(Consumer<NatGatewayAddress.Builder> ... var1);

        public Builder natGatewayId(String var1);

        public Builder provisionedBandwidth(ProvisionedBandwidth var1);

        default public Builder provisionedBandwidth(Consumer<ProvisionedBandwidth.Builder> provisionedBandwidth) {
            return this.provisionedBandwidth((ProvisionedBandwidth)((ProvisionedBandwidth.Builder)ProvisionedBandwidth.builder().applyMutation(provisionedBandwidth)).build());
        }

        public Builder state(String var1);

        public Builder state(NatGatewayState var1);

        public Builder subnetId(String var1);

        public Builder vpcId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

