/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceMonitoring;
import software.amazon.awssdk.services.ec2.model.InstanceMonitoringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitorInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, MonitorInstancesResponse> {
    private final List<InstanceMonitoring> instanceMonitorings;

    private MonitorInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceMonitorings = builder.instanceMonitorings;
    }

    public List<InstanceMonitoring> instanceMonitorings() {
        return this.instanceMonitorings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMonitorings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorInstancesResponse)) {
            return false;
        }
        MonitorInstancesResponse other = (MonitorInstancesResponse)((Object)obj);
        return Objects.equals(this.instanceMonitorings(), other.instanceMonitorings());
    }

    public String toString() {
        return ToString.builder((String)"MonitorInstancesResponse").add("InstanceMonitorings", this.instanceMonitorings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceMonitorings": {
                return Optional.ofNullable(clazz.cast(this.instanceMonitorings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<InstanceMonitoring> instanceMonitorings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorInstancesResponse model) {
            super(model);
            this.instanceMonitorings(model.instanceMonitorings);
        }

        public final Collection<InstanceMonitoring.Builder> getInstanceMonitorings() {
            return this.instanceMonitorings != null ? (Collection)this.instanceMonitorings.stream().map(InstanceMonitoring::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceMonitorings(Collection<InstanceMonitoring> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copy(instanceMonitorings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMonitorings(InstanceMonitoring ... instanceMonitorings) {
            this.instanceMonitorings(Arrays.asList(instanceMonitorings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMonitorings(Consumer<InstanceMonitoring.Builder> ... instanceMonitorings) {
            this.instanceMonitorings(Stream.of(instanceMonitorings).map(c -> (InstanceMonitoring)((InstanceMonitoring.Builder)InstanceMonitoring.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceMonitorings(Collection<InstanceMonitoring.BuilderImpl> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copyFromBuilder(instanceMonitorings);
        }

        @Override
        public MonitorInstancesResponse build() {
            return new MonitorInstancesResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, MonitorInstancesResponse> {
        public Builder instanceMonitorings(Collection<InstanceMonitoring> var1);

        public Builder instanceMonitorings(InstanceMonitoring ... var1);

        public Builder instanceMonitorings(Consumer<InstanceMonitoring.Builder> ... var1);
    }
}

