/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationListRequestCopier;
import software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceCreditSpecificationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyInstanceCreditSpecificationRequest> {
    private final String clientToken;
    private final List<InstanceCreditSpecificationRequest> instanceCreditSpecifications;

    private ModifyInstanceCreditSpecificationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.instanceCreditSpecifications = builder.instanceCreditSpecifications;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public List<InstanceCreditSpecificationRequest> instanceCreditSpecifications() {
        return this.instanceCreditSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCreditSpecifications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceCreditSpecificationRequest)) {
            return false;
        }
        ModifyInstanceCreditSpecificationRequest other = (ModifyInstanceCreditSpecificationRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.instanceCreditSpecifications(), other.instanceCreditSpecifications());
    }

    public String toString() {
        return ToString.builder((String)"ModifyInstanceCreditSpecificationRequest").add("ClientToken", (Object)this.clientToken()).add("InstanceCreditSpecifications", this.instanceCreditSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "InstanceCreditSpecifications": {
                return Optional.ofNullable(clazz.cast(this.instanceCreditSpecifications()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private List<InstanceCreditSpecificationRequest> instanceCreditSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceCreditSpecificationRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.instanceCreditSpecifications(model.instanceCreditSpecifications);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<InstanceCreditSpecificationRequest.Builder> getInstanceCreditSpecifications() {
            return this.instanceCreditSpecifications != null ? (Collection)this.instanceCreditSpecifications.stream().map(InstanceCreditSpecificationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceCreditSpecifications(Collection<InstanceCreditSpecificationRequest> instanceCreditSpecifications) {
            this.instanceCreditSpecifications = InstanceCreditSpecificationListRequestCopier.copy(instanceCreditSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCreditSpecifications(InstanceCreditSpecificationRequest ... instanceCreditSpecifications) {
            this.instanceCreditSpecifications(Arrays.asList(instanceCreditSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCreditSpecifications(Consumer<InstanceCreditSpecificationRequest.Builder> ... instanceCreditSpecifications) {
            this.instanceCreditSpecifications(Stream.of(instanceCreditSpecifications).map(c -> (InstanceCreditSpecificationRequest)((InstanceCreditSpecificationRequest.Builder)InstanceCreditSpecificationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceCreditSpecifications(Collection<InstanceCreditSpecificationRequest.BuilderImpl> instanceCreditSpecifications) {
            this.instanceCreditSpecifications = InstanceCreditSpecificationListRequestCopier.copyFromBuilder(instanceCreditSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceCreditSpecificationRequest build() {
            return new ModifyInstanceCreditSpecificationRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, ModifyInstanceCreditSpecificationRequest> {
        public Builder clientToken(String var1);

        public Builder instanceCreditSpecifications(Collection<InstanceCreditSpecificationRequest> var1);

        public Builder instanceCreditSpecifications(InstanceCreditSpecificationRequest ... var1);

        public Builder instanceCreditSpecifications(Consumer<InstanceCreditSpecificationRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

