/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateOverrides;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateOverridesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateConfig
implements ToCopyableBuilder<Builder, LaunchTemplateConfig> {
    private final FleetLaunchTemplateSpecification launchTemplateSpecification;
    private final List<LaunchTemplateOverrides> overrides;

    private LaunchTemplateConfig(BuilderImpl builder) {
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
        this.overrides = builder.overrides;
    }

    public FleetLaunchTemplateSpecification launchTemplateSpecification() {
        return this.launchTemplateSpecification;
    }

    public List<LaunchTemplateOverrides> overrides() {
        return this.overrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateConfig)) {
            return false;
        }
        LaunchTemplateConfig other = (LaunchTemplateConfig)obj;
        return Objects.equals(this.launchTemplateSpecification(), other.launchTemplateSpecification()) && Objects.equals(this.overrides(), other.overrides());
    }

    public String toString() {
        return ToString.builder((String)"LaunchTemplateConfig").add("LaunchTemplateSpecification", (Object)this.launchTemplateSpecification()).add("Overrides", this.overrides()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateSpecification": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateSpecification()));
            }
            case "Overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private FleetLaunchTemplateSpecification launchTemplateSpecification;
        private List<LaunchTemplateOverrides> overrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateConfig model) {
            this.launchTemplateSpecification(model.launchTemplateSpecification);
            this.overrides(model.overrides);
        }

        public final FleetLaunchTemplateSpecification.Builder getLaunchTemplateSpecification() {
            return this.launchTemplateSpecification != null ? this.launchTemplateSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateSpecification(FleetLaunchTemplateSpecification launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final void setLaunchTemplateSpecification(FleetLaunchTemplateSpecification.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        public final Collection<LaunchTemplateOverrides.Builder> getOverrides() {
            return this.overrides != null ? (Collection)this.overrides.stream().map(LaunchTemplateOverrides::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder overrides(Collection<LaunchTemplateOverrides> overrides) {
            this.overrides = LaunchTemplateOverridesListCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(LaunchTemplateOverrides ... overrides) {
            this.overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<LaunchTemplateOverrides.Builder> ... overrides) {
            this.overrides(Stream.of(overrides).map(c -> (LaunchTemplateOverrides)((LaunchTemplateOverrides.Builder)LaunchTemplateOverrides.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOverrides(Collection<LaunchTemplateOverrides.BuilderImpl> overrides) {
            this.overrides = LaunchTemplateOverridesListCopier.copyFromBuilder(overrides);
        }

        public LaunchTemplateConfig build() {
            return new LaunchTemplateConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LaunchTemplateConfig> {
        public Builder launchTemplateSpecification(FleetLaunchTemplateSpecification var1);

        default public Builder launchTemplateSpecification(Consumer<FleetLaunchTemplateSpecification.Builder> launchTemplateSpecification) {
            return this.launchTemplateSpecification((FleetLaunchTemplateSpecification)((FleetLaunchTemplateSpecification.Builder)FleetLaunchTemplateSpecification.builder().applyMutation(launchTemplateSpecification)).build());
        }

        public Builder overrides(Collection<LaunchTemplateOverrides> var1);

        public Builder overrides(LaunchTemplateOverrides ... var1);

        public Builder overrides(Consumer<LaunchTemplateOverrides.Builder> ... var1);
    }
}

