/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.EventInformation;
import software.amazon.awssdk.services.ec2.model.EventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HistoryRecord
implements ToCopyableBuilder<Builder, HistoryRecord> {
    private final EventInformation eventInformation;
    private final String eventType;
    private final Instant timestamp;

    private HistoryRecord(BuilderImpl builder) {
        this.eventInformation = builder.eventInformation;
        this.eventType = builder.eventType;
        this.timestamp = builder.timestamp;
    }

    public EventInformation eventInformation() {
        return this.eventInformation;
    }

    public EventType eventType() {
        return EventType.fromValue(this.eventType);
    }

    public String eventTypeAsString() {
        return this.eventType;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryRecord)) {
            return false;
        }
        HistoryRecord other = (HistoryRecord)obj;
        return Objects.equals(this.eventInformation(), other.eventInformation()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"HistoryRecord").add("EventInformation", (Object)this.eventInformation()).add("EventType", (Object)this.eventTypeAsString()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventInformation": {
                return Optional.ofNullable(clazz.cast(this.eventInformation()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private EventInformation eventInformation;
        private String eventType;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoryRecord model) {
            this.eventInformation(model.eventInformation);
            this.eventType(model.eventType);
            this.timestamp(model.timestamp);
        }

        public final EventInformation.Builder getEventInformation() {
            return this.eventInformation != null ? this.eventInformation.toBuilder() : null;
        }

        @Override
        public final Builder eventInformation(EventInformation eventInformation) {
            this.eventInformation = eventInformation;
            return this;
        }

        public final void setEventInformation(EventInformation.BuilderImpl eventInformation) {
            this.eventInformation = eventInformation != null ? eventInformation.build() : null;
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public HistoryRecord build() {
            return new HistoryRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HistoryRecord> {
        public Builder eventInformation(EventInformation var1);

        default public Builder eventInformation(Consumer<EventInformation.Builder> eventInformation) {
            return this.eventInformation((EventInformation)((EventInformation.Builder)EventInformation.builder().applyMutation(eventInformation)).build());
        }

        public Builder eventType(String var1);

        public Builder eventType(EventType var1);

        public Builder timestamp(Instant var1);
    }
}

