/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ServiceConfiguration;
import software.amazon.awssdk.services.ec2.model.ServiceConfigurationSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcEndpointServiceConfigurationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcEndpointServiceConfigurationsResponse> {
    private final List<ServiceConfiguration> serviceConfigurations;
    private final String nextToken;

    private DescribeVpcEndpointServiceConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceConfigurations = builder.serviceConfigurations;
        this.nextToken = builder.nextToken;
    }

    public List<ServiceConfiguration> serviceConfigurations() {
        return this.serviceConfigurations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointServiceConfigurationsResponse)) {
            return false;
        }
        DescribeVpcEndpointServiceConfigurationsResponse other = (DescribeVpcEndpointServiceConfigurationsResponse)((Object)obj);
        return Objects.equals(this.serviceConfigurations(), other.serviceConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVpcEndpointServiceConfigurationsResponse").add("ServiceConfigurations", this.serviceConfigurations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceConfigurations": {
                return Optional.ofNullable(clazz.cast(this.serviceConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ServiceConfiguration> serviceConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointServiceConfigurationsResponse model) {
            super(model);
            this.serviceConfigurations(model.serviceConfigurations);
            this.nextToken(model.nextToken);
        }

        public final Collection<ServiceConfiguration.Builder> getServiceConfigurations() {
            return this.serviceConfigurations != null ? (Collection)this.serviceConfigurations.stream().map(ServiceConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceConfigurations(Collection<ServiceConfiguration> serviceConfigurations) {
            this.serviceConfigurations = ServiceConfigurationSetCopier.copy(serviceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceConfigurations(ServiceConfiguration ... serviceConfigurations) {
            this.serviceConfigurations(Arrays.asList(serviceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceConfigurations(Consumer<ServiceConfiguration.Builder> ... serviceConfigurations) {
            this.serviceConfigurations(Stream.of(serviceConfigurations).map(c -> (ServiceConfiguration)((ServiceConfiguration.Builder)ServiceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceConfigurations(Collection<ServiceConfiguration.BuilderImpl> serviceConfigurations) {
            this.serviceConfigurations = ServiceConfigurationSetCopier.copyFromBuilder(serviceConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointServiceConfigurationsResponse build() {
            return new DescribeVpcEndpointServiceConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeVpcEndpointServiceConfigurationsResponse> {
        public Builder serviceConfigurations(Collection<ServiceConfiguration> var1);

        public Builder serviceConfigurations(ServiceConfiguration ... var1);

        public Builder serviceConfigurations(Consumer<ServiceConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

