/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VpcEndpointConnection;
import software.amazon.awssdk.services.ec2.model.VpcEndpointConnectionSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcEndpointConnectionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcEndpointConnectionsResponse> {
    private final List<VpcEndpointConnection> vpcEndpointConnections;
    private final String nextToken;

    private DescribeVpcEndpointConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointConnections = builder.vpcEndpointConnections;
        this.nextToken = builder.nextToken;
    }

    public List<VpcEndpointConnection> vpcEndpointConnections() {
        return this.vpcEndpointConnections;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointConnections());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointConnectionsResponse)) {
            return false;
        }
        DescribeVpcEndpointConnectionsResponse other = (DescribeVpcEndpointConnectionsResponse)((Object)obj);
        return Objects.equals(this.vpcEndpointConnections(), other.vpcEndpointConnections()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVpcEndpointConnectionsResponse").add("VpcEndpointConnections", this.vpcEndpointConnections()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpointConnections": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointConnections()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VpcEndpointConnection> vpcEndpointConnections = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointConnectionsResponse model) {
            super(model);
            this.vpcEndpointConnections(model.vpcEndpointConnections);
            this.nextToken(model.nextToken);
        }

        public final Collection<VpcEndpointConnection.Builder> getVpcEndpointConnections() {
            return this.vpcEndpointConnections != null ? (Collection)this.vpcEndpointConnections.stream().map(VpcEndpointConnection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcEndpointConnections(Collection<VpcEndpointConnection> vpcEndpointConnections) {
            this.vpcEndpointConnections = VpcEndpointConnectionSetCopier.copy(vpcEndpointConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointConnections(VpcEndpointConnection ... vpcEndpointConnections) {
            this.vpcEndpointConnections(Arrays.asList(vpcEndpointConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointConnections(Consumer<VpcEndpointConnection.Builder> ... vpcEndpointConnections) {
            this.vpcEndpointConnections(Stream.of(vpcEndpointConnections).map(c -> (VpcEndpointConnection)((VpcEndpointConnection.Builder)VpcEndpointConnection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcEndpointConnections(Collection<VpcEndpointConnection.BuilderImpl> vpcEndpointConnections) {
            this.vpcEndpointConnections = VpcEndpointConnectionSetCopier.copyFromBuilder(vpcEndpointConnections);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointConnectionsResponse build() {
            return new DescribeVpcEndpointConnectionsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeVpcEndpointConnectionsResponse> {
        public Builder vpcEndpointConnections(Collection<VpcEndpointConnection> var1);

        public Builder vpcEndpointConnections(VpcEndpointConnection ... var1);

        public Builder vpcEndpointConnections(Consumer<VpcEndpointConnection.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

