/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcAttributeResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcAttributeResponse> {
    private final String vpcId;
    private final Boolean enableDnsHostnames;
    private final Boolean enableDnsSupport;

    private DescribeVpcAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.vpcId = builder.vpcId;
        this.enableDnsHostnames = builder.enableDnsHostnames;
        this.enableDnsSupport = builder.enableDnsSupport;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Boolean enableDnsHostnames() {
        return this.enableDnsHostnames;
    }

    public Boolean enableDnsSupport() {
        return this.enableDnsSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDnsHostnames());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDnsSupport());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcAttributeResponse)) {
            return false;
        }
        DescribeVpcAttributeResponse other = (DescribeVpcAttributeResponse)((Object)obj);
        return Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.enableDnsHostnames(), other.enableDnsHostnames()) && Objects.equals(this.enableDnsSupport(), other.enableDnsSupport());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVpcAttributeResponse").add("VpcId", (Object)this.vpcId()).add("EnableDnsHostnames", (Object)this.enableDnsHostnames()).add("EnableDnsSupport", (Object)this.enableDnsSupport()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "EnableDnsHostnames": {
                return Optional.ofNullable(clazz.cast(this.enableDnsHostnames()));
            }
            case "EnableDnsSupport": {
                return Optional.ofNullable(clazz.cast(this.enableDnsSupport()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String vpcId;
        private Boolean enableDnsHostnames;
        private Boolean enableDnsSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcAttributeResponse model) {
            super(model);
            this.vpcId(model.vpcId);
            this.enableDnsHostnames(model.enableDnsHostnames);
            this.enableDnsSupport(model.enableDnsSupport);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Boolean getEnableDnsHostnames() {
            return this.enableDnsHostnames;
        }

        @Override
        public final Builder enableDnsHostnames(Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
            return this;
        }

        public final void setEnableDnsHostnames(Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
        }

        public final Boolean getEnableDnsSupport() {
            return this.enableDnsSupport;
        }

        @Override
        public final Builder enableDnsSupport(Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
            return this;
        }

        public final void setEnableDnsSupport(Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
        }

        @Override
        public DescribeVpcAttributeResponse build() {
            return new DescribeVpcAttributeResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeVpcAttributeResponse> {
        public Builder vpcId(String var1);

        public Builder enableDnsHostnames(Boolean var1);

        public Builder enableDnsSupport(Boolean var1);
    }
}

