/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.FlowLog;
import software.amazon.awssdk.services.ec2.model.FlowLogSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFlowLogsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeFlowLogsResponse> {
    private final List<FlowLog> flowLogs;
    private final String nextToken;

    private DescribeFlowLogsResponse(BuilderImpl builder) {
        super(builder);
        this.flowLogs = builder.flowLogs;
        this.nextToken = builder.nextToken;
    }

    public List<FlowLog> flowLogs() {
        return this.flowLogs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowLogsResponse)) {
            return false;
        }
        DescribeFlowLogsResponse other = (DescribeFlowLogsResponse)((Object)obj);
        return Objects.equals(this.flowLogs(), other.flowLogs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFlowLogsResponse").add("FlowLogs", this.flowLogs()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowLogs": {
                return Optional.ofNullable(clazz.cast(this.flowLogs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<FlowLog> flowLogs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowLogsResponse model) {
            super(model);
            this.flowLogs(model.flowLogs);
            this.nextToken(model.nextToken);
        }

        public final Collection<FlowLog.Builder> getFlowLogs() {
            return this.flowLogs != null ? (Collection)this.flowLogs.stream().map(FlowLog::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder flowLogs(Collection<FlowLog> flowLogs) {
            this.flowLogs = FlowLogSetCopier.copy(flowLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogs(FlowLog ... flowLogs) {
            this.flowLogs(Arrays.asList(flowLogs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogs(Consumer<FlowLog.Builder> ... flowLogs) {
            this.flowLogs(Stream.of(flowLogs).map(c -> (FlowLog)((FlowLog.Builder)FlowLog.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFlowLogs(Collection<FlowLog.BuilderImpl> flowLogs) {
            this.flowLogs = FlowLogSetCopier.copyFromBuilder(flowLogs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFlowLogsResponse build() {
            return new DescribeFlowLogsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeFlowLogsResponse> {
        public Builder flowLogs(Collection<FlowLog> var1);

        public Builder flowLogs(FlowLog ... var1);

        public Builder flowLogs(Consumer<FlowLog.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

