/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.HistoryRecordEntry;
import software.amazon.awssdk.services.ec2.model.HistoryRecordSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetHistoryResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeFleetHistoryResponse> {
    private final List<HistoryRecordEntry> historyRecords;
    private final Instant lastEvaluatedTime;
    private final String nextToken;
    private final String fleetId;
    private final Instant startTime;

    private DescribeFleetHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.historyRecords = builder.historyRecords;
        this.lastEvaluatedTime = builder.lastEvaluatedTime;
        this.nextToken = builder.nextToken;
        this.fleetId = builder.fleetId;
        this.startTime = builder.startTime;
    }

    public List<HistoryRecordEntry> historyRecords() {
        return this.historyRecords;
    }

    public Instant lastEvaluatedTime() {
        return this.lastEvaluatedTime;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.historyRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetHistoryResponse)) {
            return false;
        }
        DescribeFleetHistoryResponse other = (DescribeFleetHistoryResponse)((Object)obj);
        return Objects.equals(this.historyRecords(), other.historyRecords()) && Objects.equals(this.lastEvaluatedTime(), other.lastEvaluatedTime()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.startTime(), other.startTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFleetHistoryResponse").add("HistoryRecords", this.historyRecords()).add("LastEvaluatedTime", (Object)this.lastEvaluatedTime()).add("NextToken", (Object)this.nextToken()).add("FleetId", (Object)this.fleetId()).add("StartTime", (Object)this.startTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HistoryRecords": {
                return Optional.ofNullable(clazz.cast(this.historyRecords()));
            }
            case "LastEvaluatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedTime()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<HistoryRecordEntry> historyRecords = DefaultSdkAutoConstructList.getInstance();
        private Instant lastEvaluatedTime;
        private String nextToken;
        private String fleetId;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetHistoryResponse model) {
            super(model);
            this.historyRecords(model.historyRecords);
            this.lastEvaluatedTime(model.lastEvaluatedTime);
            this.nextToken(model.nextToken);
            this.fleetId(model.fleetId);
            this.startTime(model.startTime);
        }

        public final Collection<HistoryRecordEntry.Builder> getHistoryRecords() {
            return this.historyRecords != null ? (Collection)this.historyRecords.stream().map(HistoryRecordEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder historyRecords(Collection<HistoryRecordEntry> historyRecords) {
            this.historyRecords = HistoryRecordSetCopier.copy(historyRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historyRecords(HistoryRecordEntry ... historyRecords) {
            this.historyRecords(Arrays.asList(historyRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historyRecords(Consumer<HistoryRecordEntry.Builder> ... historyRecords) {
            this.historyRecords(Stream.of(historyRecords).map(c -> (HistoryRecordEntry)((HistoryRecordEntry.Builder)HistoryRecordEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHistoryRecords(Collection<HistoryRecordEntry.BuilderImpl> historyRecords) {
            this.historyRecords = HistoryRecordSetCopier.copyFromBuilder(historyRecords);
        }

        public final Instant getLastEvaluatedTime() {
            return this.lastEvaluatedTime;
        }

        @Override
        public final Builder lastEvaluatedTime(Instant lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
            return this;
        }

        public final void setLastEvaluatedTime(Instant lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public DescribeFleetHistoryResponse build() {
            return new DescribeFleetHistoryResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeFleetHistoryResponse> {
        public Builder historyRecords(Collection<HistoryRecordEntry> var1);

        public Builder historyRecords(HistoryRecordEntry ... var1);

        public Builder historyRecords(Consumer<HistoryRecordEntry.Builder> ... var1);

        public Builder lastEvaluatedTime(Instant var1);

        public Builder nextToken(String var1);

        public Builder fleetId(String var1);

        public Builder startTime(Instant var1);
    }
}

