/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteVpcEndpointConnectionNotificationsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteVpcEndpointConnectionNotificationsRequest> {
    private final List<String> connectionNotificationIds;

    private DeleteVpcEndpointConnectionNotificationsRequest(BuilderImpl builder) {
        super(builder);
        this.connectionNotificationIds = builder.connectionNotificationIds;
    }

    public List<String> connectionNotificationIds() {
        return this.connectionNotificationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointConnectionNotificationsRequest)) {
            return false;
        }
        DeleteVpcEndpointConnectionNotificationsRequest other = (DeleteVpcEndpointConnectionNotificationsRequest)((Object)obj);
        return Objects.equals(this.connectionNotificationIds(), other.connectionNotificationIds());
    }

    public String toString() {
        return ToString.builder((String)"DeleteVpcEndpointConnectionNotificationsRequest").add("ConnectionNotificationIds", this.connectionNotificationIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionNotificationIds": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> connectionNotificationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointConnectionNotificationsRequest model) {
            super(model);
            this.connectionNotificationIds(model.connectionNotificationIds);
        }

        public final Collection<String> getConnectionNotificationIds() {
            return this.connectionNotificationIds;
        }

        @Override
        public final Builder connectionNotificationIds(Collection<String> connectionNotificationIds) {
            this.connectionNotificationIds = ValueStringListCopier.copy(connectionNotificationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNotificationIds(String ... connectionNotificationIds) {
            this.connectionNotificationIds(Arrays.asList(connectionNotificationIds));
            return this;
        }

        public final void setConnectionNotificationIds(Collection<String> connectionNotificationIds) {
            this.connectionNotificationIds = ValueStringListCopier.copy(connectionNotificationIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpcEndpointConnectionNotificationsRequest build() {
            return new DeleteVpcEndpointConnectionNotificationsRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DeleteVpcEndpointConnectionNotificationsRequest> {
        public Builder connectionNotificationIds(Collection<String> var1);

        public Builder connectionNotificationIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

