/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.FleetStateCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFleetSuccessItem
implements ToCopyableBuilder<Builder, DeleteFleetSuccessItem> {
    private final String currentFleetState;
    private final String previousFleetState;
    private final String fleetId;

    private DeleteFleetSuccessItem(BuilderImpl builder) {
        this.currentFleetState = builder.currentFleetState;
        this.previousFleetState = builder.previousFleetState;
        this.fleetId = builder.fleetId;
    }

    public FleetStateCode currentFleetState() {
        return FleetStateCode.fromValue(this.currentFleetState);
    }

    public String currentFleetStateAsString() {
        return this.currentFleetState;
    }

    public FleetStateCode previousFleetState() {
        return FleetStateCode.fromValue(this.previousFleetState);
    }

    public String previousFleetStateAsString() {
        return this.previousFleetState;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentFleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousFleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFleetSuccessItem)) {
            return false;
        }
        DeleteFleetSuccessItem other = (DeleteFleetSuccessItem)obj;
        return Objects.equals(this.currentFleetStateAsString(), other.currentFleetStateAsString()) && Objects.equals(this.previousFleetStateAsString(), other.previousFleetStateAsString()) && Objects.equals(this.fleetId(), other.fleetId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteFleetSuccessItem").add("CurrentFleetState", (Object)this.currentFleetStateAsString()).add("PreviousFleetState", (Object)this.previousFleetStateAsString()).add("FleetId", (Object)this.fleetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentFleetState": {
                return Optional.ofNullable(clazz.cast(this.currentFleetStateAsString()));
            }
            case "PreviousFleetState": {
                return Optional.ofNullable(clazz.cast(this.previousFleetStateAsString()));
            }
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String currentFleetState;
        private String previousFleetState;
        private String fleetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFleetSuccessItem model) {
            this.currentFleetState(model.currentFleetState);
            this.previousFleetState(model.previousFleetState);
            this.fleetId(model.fleetId);
        }

        public final String getCurrentFleetState() {
            return this.currentFleetState;
        }

        @Override
        public final Builder currentFleetState(String currentFleetState) {
            this.currentFleetState = currentFleetState;
            return this;
        }

        @Override
        public final Builder currentFleetState(FleetStateCode currentFleetState) {
            this.currentFleetState(currentFleetState.toString());
            return this;
        }

        public final void setCurrentFleetState(String currentFleetState) {
            this.currentFleetState = currentFleetState;
        }

        public final String getPreviousFleetState() {
            return this.previousFleetState;
        }

        @Override
        public final Builder previousFleetState(String previousFleetState) {
            this.previousFleetState = previousFleetState;
            return this;
        }

        @Override
        public final Builder previousFleetState(FleetStateCode previousFleetState) {
            this.previousFleetState(previousFleetState.toString());
            return this;
        }

        public final void setPreviousFleetState(String previousFleetState) {
            this.previousFleetState = previousFleetState;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public DeleteFleetSuccessItem build() {
            return new DeleteFleetSuccessItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteFleetSuccessItem> {
        public Builder currentFleetState(String var1);

        public Builder currentFleetState(FleetStateCode var1);

        public Builder previousFleetState(String var1);

        public Builder previousFleetState(FleetStateCode var1);

        public Builder fleetId(String var1);
    }
}

