/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcPeeringConnectionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVpcPeeringConnectionRequest> {
    private final String peerOwnerId;
    private final String peerVpcId;
    private final String vpcId;
    private final String peerRegion;

    private CreateVpcPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.peerOwnerId = builder.peerOwnerId;
        this.peerVpcId = builder.peerVpcId;
        this.vpcId = builder.vpcId;
        this.peerRegion = builder.peerRegion;
    }

    public String peerOwnerId() {
        return this.peerOwnerId;
    }

    public String peerVpcId() {
        return this.peerVpcId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String peerRegion() {
        return this.peerRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.peerOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcPeeringConnectionRequest)) {
            return false;
        }
        CreateVpcPeeringConnectionRequest other = (CreateVpcPeeringConnectionRequest)((Object)obj);
        return Objects.equals(this.peerOwnerId(), other.peerOwnerId()) && Objects.equals(this.peerVpcId(), other.peerVpcId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.peerRegion(), other.peerRegion());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpcPeeringConnectionRequest").add("PeerOwnerId", (Object)this.peerOwnerId()).add("PeerVpcId", (Object)this.peerVpcId()).add("VpcId", (Object)this.vpcId()).add("PeerRegion", (Object)this.peerRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PeerOwnerId": {
                return Optional.ofNullable(clazz.cast(this.peerOwnerId()));
            }
            case "PeerVpcId": {
                return Optional.ofNullable(clazz.cast(this.peerVpcId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "PeerRegion": {
                return Optional.ofNullable(clazz.cast(this.peerRegion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String peerOwnerId;
        private String peerVpcId;
        private String vpcId;
        private String peerRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcPeeringConnectionRequest model) {
            super(model);
            this.peerOwnerId(model.peerOwnerId);
            this.peerVpcId(model.peerVpcId);
            this.vpcId(model.vpcId);
            this.peerRegion(model.peerRegion);
        }

        public final String getPeerOwnerId() {
            return this.peerOwnerId;
        }

        @Override
        public final Builder peerOwnerId(String peerOwnerId) {
            this.peerOwnerId = peerOwnerId;
            return this;
        }

        public final void setPeerOwnerId(String peerOwnerId) {
            this.peerOwnerId = peerOwnerId;
        }

        public final String getPeerVpcId() {
            return this.peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getPeerRegion() {
            return this.peerRegion;
        }

        @Override
        public final Builder peerRegion(String peerRegion) {
            this.peerRegion = peerRegion;
            return this;
        }

        public final void setPeerRegion(String peerRegion) {
            this.peerRegion = peerRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcPeeringConnectionRequest build() {
            return new CreateVpcPeeringConnectionRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, CreateVpcPeeringConnectionRequest> {
        public Builder peerOwnerId(String var1);

        public Builder peerVpcId(String var1);

        public Builder vpcId(String var1);

        public Builder peerRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

