/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLaunchTemplateVersionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateLaunchTemplateVersionRequest> {
    private final String clientToken;
    private final String launchTemplateId;
    private final String launchTemplateName;
    private final String sourceVersion;
    private final String versionDescription;
    private final RequestLaunchTemplateData launchTemplateData;

    private CreateLaunchTemplateVersionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.sourceVersion = builder.sourceVersion;
        this.versionDescription = builder.versionDescription;
        this.launchTemplateData = builder.launchTemplateData;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String launchTemplateId() {
        return this.launchTemplateId;
    }

    public String launchTemplateName() {
        return this.launchTemplateName;
    }

    public String sourceVersion() {
        return this.sourceVersion;
    }

    public String versionDescription() {
        return this.versionDescription;
    }

    public RequestLaunchTemplateData launchTemplateData() {
        return this.launchTemplateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchTemplateVersionRequest)) {
            return false;
        }
        CreateLaunchTemplateVersionRequest other = (CreateLaunchTemplateVersionRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.launchTemplateId(), other.launchTemplateId()) && Objects.equals(this.launchTemplateName(), other.launchTemplateName()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.launchTemplateData(), other.launchTemplateData());
    }

    public String toString() {
        return ToString.builder((String)"CreateLaunchTemplateVersionRequest").add("ClientToken", (Object)this.clientToken()).add("LaunchTemplateId", (Object)this.launchTemplateId()).add("LaunchTemplateName", (Object)this.launchTemplateName()).add("SourceVersion", (Object)this.sourceVersion()).add("VersionDescription", (Object)this.versionDescription()).add("LaunchTemplateData", (Object)this.launchTemplateData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "LaunchTemplateId": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateId()));
            }
            case "LaunchTemplateName": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateName()));
            }
            case "SourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "LaunchTemplateData": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private String launchTemplateId;
        private String launchTemplateName;
        private String sourceVersion;
        private String versionDescription;
        private RequestLaunchTemplateData launchTemplateData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchTemplateVersionRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.launchTemplateId(model.launchTemplateId);
            this.launchTemplateName(model.launchTemplateName);
            this.sourceVersion(model.sourceVersion);
            this.versionDescription(model.versionDescription);
            this.launchTemplateData(model.launchTemplateData);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getLaunchTemplateId() {
            return this.launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        public final String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        public final RequestLaunchTemplateData.Builder getLaunchTemplateData() {
            return this.launchTemplateData != null ? this.launchTemplateData.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateData(RequestLaunchTemplateData launchTemplateData) {
            this.launchTemplateData = launchTemplateData;
            return this;
        }

        public final void setLaunchTemplateData(RequestLaunchTemplateData.BuilderImpl launchTemplateData) {
            this.launchTemplateData = launchTemplateData != null ? launchTemplateData.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLaunchTemplateVersionRequest build() {
            return new CreateLaunchTemplateVersionRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, CreateLaunchTemplateVersionRequest> {
        public Builder clientToken(String var1);

        public Builder launchTemplateId(String var1);

        public Builder launchTemplateName(String var1);

        public Builder sourceVersion(String var1);

        public Builder versionDescription(String var1);

        public Builder launchTemplateData(RequestLaunchTemplateData var1);

        default public Builder launchTemplateData(Consumer<RequestLaunchTemplateData.Builder> launchTemplateData) {
            return this.launchTemplateData((RequestLaunchTemplateData)((RequestLaunchTemplateData.Builder)RequestLaunchTemplateData.builder().applyMutation(launchTemplateData)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

