/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ConnectionNotificationState;
import software.amazon.awssdk.services.ec2.model.ConnectionNotificationType;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionNotification
implements ToCopyableBuilder<Builder, ConnectionNotification> {
    private final String connectionNotificationId;
    private final String serviceId;
    private final String vpcEndpointId;
    private final String connectionNotificationType;
    private final String connectionNotificationArn;
    private final List<String> connectionEvents;
    private final String connectionNotificationState;

    private ConnectionNotification(BuilderImpl builder) {
        this.connectionNotificationId = builder.connectionNotificationId;
        this.serviceId = builder.serviceId;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.connectionNotificationType = builder.connectionNotificationType;
        this.connectionNotificationArn = builder.connectionNotificationArn;
        this.connectionEvents = builder.connectionEvents;
        this.connectionNotificationState = builder.connectionNotificationState;
    }

    public String connectionNotificationId() {
        return this.connectionNotificationId;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public ConnectionNotificationType connectionNotificationType() {
        return ConnectionNotificationType.fromValue(this.connectionNotificationType);
    }

    public String connectionNotificationTypeAsString() {
        return this.connectionNotificationType;
    }

    public String connectionNotificationArn() {
        return this.connectionNotificationArn;
    }

    public List<String> connectionEvents() {
        return this.connectionEvents;
    }

    public ConnectionNotificationState connectionNotificationState() {
        return ConnectionNotificationState.fromValue(this.connectionNotificationState);
    }

    public String connectionNotificationStateAsString() {
        return this.connectionNotificationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationStateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionNotification)) {
            return false;
        }
        ConnectionNotification other = (ConnectionNotification)obj;
        return Objects.equals(this.connectionNotificationId(), other.connectionNotificationId()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.connectionNotificationTypeAsString(), other.connectionNotificationTypeAsString()) && Objects.equals(this.connectionNotificationArn(), other.connectionNotificationArn()) && Objects.equals(this.connectionEvents(), other.connectionEvents()) && Objects.equals(this.connectionNotificationStateAsString(), other.connectionNotificationStateAsString());
    }

    public String toString() {
        return ToString.builder((String)"ConnectionNotification").add("ConnectionNotificationId", (Object)this.connectionNotificationId()).add("ServiceId", (Object)this.serviceId()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("ConnectionNotificationType", (Object)this.connectionNotificationTypeAsString()).add("ConnectionNotificationArn", (Object)this.connectionNotificationArn()).add("ConnectionEvents", this.connectionEvents()).add("ConnectionNotificationState", (Object)this.connectionNotificationStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionNotificationId": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationId()));
            }
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "ConnectionNotificationType": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationTypeAsString()));
            }
            case "ConnectionNotificationArn": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationArn()));
            }
            case "ConnectionEvents": {
                return Optional.ofNullable(clazz.cast(this.connectionEvents()));
            }
            case "ConnectionNotificationState": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationStateAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionNotificationId;
        private String serviceId;
        private String vpcEndpointId;
        private String connectionNotificationType;
        private String connectionNotificationArn;
        private List<String> connectionEvents = DefaultSdkAutoConstructList.getInstance();
        private String connectionNotificationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionNotification model) {
            this.connectionNotificationId(model.connectionNotificationId);
            this.serviceId(model.serviceId);
            this.vpcEndpointId(model.vpcEndpointId);
            this.connectionNotificationType(model.connectionNotificationType);
            this.connectionNotificationArn(model.connectionNotificationArn);
            this.connectionEvents(model.connectionEvents);
            this.connectionNotificationState(model.connectionNotificationState);
        }

        public final String getConnectionNotificationId() {
            return this.connectionNotificationId;
        }

        @Override
        public final Builder connectionNotificationId(String connectionNotificationId) {
            this.connectionNotificationId = connectionNotificationId;
            return this;
        }

        public final void setConnectionNotificationId(String connectionNotificationId) {
            this.connectionNotificationId = connectionNotificationId;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final String getConnectionNotificationType() {
            return this.connectionNotificationType;
        }

        @Override
        public final Builder connectionNotificationType(String connectionNotificationType) {
            this.connectionNotificationType = connectionNotificationType;
            return this;
        }

        @Override
        public final Builder connectionNotificationType(ConnectionNotificationType connectionNotificationType) {
            this.connectionNotificationType(connectionNotificationType.toString());
            return this;
        }

        public final void setConnectionNotificationType(String connectionNotificationType) {
            this.connectionNotificationType = connectionNotificationType;
        }

        public final String getConnectionNotificationArn() {
            return this.connectionNotificationArn;
        }

        @Override
        public final Builder connectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
            return this;
        }

        public final void setConnectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
        }

        public final Collection<String> getConnectionEvents() {
            return this.connectionEvents;
        }

        @Override
        public final Builder connectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionEvents(String ... connectionEvents) {
            this.connectionEvents(Arrays.asList(connectionEvents));
            return this;
        }

        public final void setConnectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
        }

        public final String getConnectionNotificationState() {
            return this.connectionNotificationState;
        }

        @Override
        public final Builder connectionNotificationState(String connectionNotificationState) {
            this.connectionNotificationState = connectionNotificationState;
            return this;
        }

        @Override
        public final Builder connectionNotificationState(ConnectionNotificationState connectionNotificationState) {
            this.connectionNotificationState(connectionNotificationState.toString());
            return this;
        }

        public final void setConnectionNotificationState(String connectionNotificationState) {
            this.connectionNotificationState = connectionNotificationState;
        }

        public ConnectionNotification build() {
            return new ConnectionNotification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConnectionNotification> {
        public Builder connectionNotificationId(String var1);

        public Builder serviceId(String var1);

        public Builder vpcEndpointId(String var1);

        public Builder connectionNotificationType(String var1);

        public Builder connectionNotificationType(ConnectionNotificationType var1);

        public Builder connectionNotificationArn(String var1);

        public Builder connectionEvents(Collection<String> var1);

        public Builder connectionEvents(String ... var1);

        public Builder connectionNotificationState(String var1);

        public Builder connectionNotificationState(ConnectionNotificationState var1);
    }
}

