/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class TagSpecificationUnmarshaller
implements Unmarshaller<TagSpecification, StaxUnmarshallerContext> {
    private static final TagSpecificationUnmarshaller INSTANCE = new TagSpecificationUnmarshaller();

    public TagSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        TagSpecification.Builder tagSpecification;
        block6: {
            tagSpecification = TagSpecification.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    tagSpecification.tags(tags);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("resourceType", targetDepth)) {
                        tagSpecification.resourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Tag", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("Tag/item", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            tagSpecification.tags(tags);
        }
        return (TagSpecification)tagSpecification.build();
    }

    public static TagSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

