/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;

public class StopInstancesRequestMarshaller
implements Marshaller<Request<StopInstancesRequest>, StopInstancesRequest> {
    public Request<StopInstancesRequest> marshall(StopInstancesRequest stopInstancesRequest) {
        if (stopInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)stopInstancesRequest, "Ec2Client");
        request.addParameter("Action", "StopInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> stopInstancesRequestInstanceIdsList = stopInstancesRequest.instanceIds();
        if (!stopInstancesRequestInstanceIdsList.isEmpty() || !(stopInstancesRequestInstanceIdsList instanceof SdkAutoConstructList)) {
            int instanceIdsListIndex = 1;
            for (String stopInstancesRequestInstanceIdsListValue : stopInstancesRequestInstanceIdsList) {
                if (stopInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringConversion.fromString((String)stopInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (stopInstancesRequest.force() != null) {
            request.addParameter("Force", StringConversion.fromBoolean((Boolean)stopInstancesRequest.force()));
        }
        return request;
    }
}

