/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest;

public class ResetFpgaImageAttributeRequestMarshaller
implements Marshaller<Request<ResetFpgaImageAttributeRequest>, ResetFpgaImageAttributeRequest> {
    public Request<ResetFpgaImageAttributeRequest> marshall(ResetFpgaImageAttributeRequest resetFpgaImageAttributeRequest) {
        if (resetFpgaImageAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)resetFpgaImageAttributeRequest, "Ec2Client");
        request.addParameter("Action", "ResetFpgaImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetFpgaImageAttributeRequest.fpgaImageId() != null) {
            request.addParameter("FpgaImageId", StringConversion.fromString((String)resetFpgaImageAttributeRequest.fpgaImageId()));
        }
        if (resetFpgaImageAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringConversion.fromString((String)resetFpgaImageAttributeRequest.attributeAsString()));
        }
        return request;
    }
}

