/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest;

public class ReplaceRouteTableAssociationRequestMarshaller
implements Marshaller<Request<ReplaceRouteTableAssociationRequest>, ReplaceRouteTableAssociationRequest> {
    public Request<ReplaceRouteTableAssociationRequest> marshall(ReplaceRouteTableAssociationRequest replaceRouteTableAssociationRequest) {
        if (replaceRouteTableAssociationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)replaceRouteTableAssociationRequest, "Ec2Client");
        request.addParameter("Action", "ReplaceRouteTableAssociation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (replaceRouteTableAssociationRequest.associationId() != null) {
            request.addParameter("AssociationId", StringConversion.fromString((String)replaceRouteTableAssociationRequest.associationId()));
        }
        if (replaceRouteTableAssociationRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringConversion.fromString((String)replaceRouteTableAssociationRequest.routeTableId()));
        }
        return request;
    }
}

