/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest;

public class ReleaseHostsRequestMarshaller
implements Marshaller<Request<ReleaseHostsRequest>, ReleaseHostsRequest> {
    public Request<ReleaseHostsRequest> marshall(ReleaseHostsRequest releaseHostsRequest) {
        if (releaseHostsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)releaseHostsRequest, "Ec2Client");
        request.addParameter("Action", "ReleaseHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> releaseHostsRequestHostIdsList = releaseHostsRequest.hostIds();
        if (!releaseHostsRequestHostIdsList.isEmpty() || !(releaseHostsRequestHostIdsList instanceof SdkAutoConstructList)) {
            int hostIdsListIndex = 1;
            for (String releaseHostsRequestHostIdsListValue : releaseHostsRequestHostIdsList) {
                if (releaseHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringConversion.fromString((String)releaseHostsRequestHostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        return request;
    }
}

