/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest;

public class ReleaseAddressRequestMarshaller
implements Marshaller<Request<ReleaseAddressRequest>, ReleaseAddressRequest> {
    public Request<ReleaseAddressRequest> marshall(ReleaseAddressRequest releaseAddressRequest) {
        if (releaseAddressRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)releaseAddressRequest, "Ec2Client");
        request.addParameter("Action", "ReleaseAddress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (releaseAddressRequest.allocationId() != null) {
            request.addParameter("AllocationId", StringConversion.fromString((String)releaseAddressRequest.allocationId()));
        }
        if (releaseAddressRequest.publicIp() != null) {
            request.addParameter("PublicIp", StringConversion.fromString((String)releaseAddressRequest.publicIp()));
        }
        return request;
    }
}

