/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest;
import software.amazon.awssdk.services.ec2.model.PeeringConnectionOptionsRequest;

public class ModifyVpcPeeringConnectionOptionsRequestMarshaller
implements Marshaller<Request<ModifyVpcPeeringConnectionOptionsRequest>, ModifyVpcPeeringConnectionOptionsRequest> {
    public Request<ModifyVpcPeeringConnectionOptionsRequest> marshall(ModifyVpcPeeringConnectionOptionsRequest modifyVpcPeeringConnectionOptionsRequest) {
        PeeringConnectionOptionsRequest requesterPeeringConnectionOptions;
        if (modifyVpcPeeringConnectionOptionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyVpcPeeringConnectionOptionsRequest, "Ec2Client");
        request.addParameter("Action", "ModifyVpcPeeringConnectionOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        PeeringConnectionOptionsRequest accepterPeeringConnectionOptions = modifyVpcPeeringConnectionOptionsRequest.accepterPeeringConnectionOptions();
        if (accepterPeeringConnectionOptions != null) {
            if (accepterPeeringConnectionOptions.allowDnsResolutionFromRemoteVpc() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowDnsResolutionFromRemoteVpc", StringConversion.fromBoolean((Boolean)accepterPeeringConnectionOptions.allowDnsResolutionFromRemoteVpc()));
            }
            if (accepterPeeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowEgressFromLocalClassicLinkToRemoteVpc", StringConversion.fromBoolean((Boolean)accepterPeeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc()));
            }
            if (accepterPeeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowEgressFromLocalVpcToRemoteClassicLink", StringConversion.fromBoolean((Boolean)accepterPeeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink()));
            }
        }
        if ((requesterPeeringConnectionOptions = modifyVpcPeeringConnectionOptionsRequest.requesterPeeringConnectionOptions()) != null) {
            if (requesterPeeringConnectionOptions.allowDnsResolutionFromRemoteVpc() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowDnsResolutionFromRemoteVpc", StringConversion.fromBoolean((Boolean)requesterPeeringConnectionOptions.allowDnsResolutionFromRemoteVpc()));
            }
            if (requesterPeeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowEgressFromLocalClassicLinkToRemoteVpc", StringConversion.fromBoolean((Boolean)requesterPeeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc()));
            }
            if (requesterPeeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowEgressFromLocalVpcToRemoteClassicLink", StringConversion.fromBoolean((Boolean)requesterPeeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink()));
            }
        }
        if (modifyVpcPeeringConnectionOptionsRequest.vpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringConversion.fromString((String)modifyVpcPeeringConnectionOptionsRequest.vpcPeeringConnectionId()));
        }
        return request;
    }
}

