/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ClientData;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer;
import software.amazon.awssdk.services.ec2.model.UserBucket;

public class ImportSnapshotRequestMarshaller
implements Marshaller<Request<ImportSnapshotRequest>, ImportSnapshotRequest> {
    public Request<ImportSnapshotRequest> marshall(ImportSnapshotRequest importSnapshotRequest) {
        SnapshotDiskContainer diskContainer;
        if (importSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)importSnapshotRequest, "Ec2Client");
        request.addParameter("Action", "ImportSnapshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        ClientData clientData = importSnapshotRequest.clientData();
        if (clientData != null) {
            if (clientData.comment() != null) {
                request.addParameter("ClientData.Comment", StringConversion.fromString((String)clientData.comment()));
            }
            if (clientData.uploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringConversion.fromInstant((Instant)clientData.uploadEnd()));
            }
            if (clientData.uploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringConversion.fromDouble((Double)clientData.uploadSize()));
            }
            if (clientData.uploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringConversion.fromInstant((Instant)clientData.uploadStart()));
            }
        }
        if (importSnapshotRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)importSnapshotRequest.clientToken()));
        }
        if (importSnapshotRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)importSnapshotRequest.description()));
        }
        if ((diskContainer = importSnapshotRequest.diskContainer()) != null) {
            UserBucket userBucket;
            if (diskContainer.description() != null) {
                request.addParameter("DiskContainer.Description", StringConversion.fromString((String)diskContainer.description()));
            }
            if (diskContainer.format() != null) {
                request.addParameter("DiskContainer.Format", StringConversion.fromString((String)diskContainer.format()));
            }
            if (diskContainer.url() != null) {
                request.addParameter("DiskContainer.Url", StringConversion.fromString((String)diskContainer.url()));
            }
            if ((userBucket = diskContainer.userBucket()) != null) {
                if (userBucket.s3Bucket() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Bucket", StringConversion.fromString((String)userBucket.s3Bucket()));
                }
                if (userBucket.s3Key() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Key", StringConversion.fromString((String)userBucket.s3Key()));
                }
            }
        }
        if (importSnapshotRequest.roleName() != null) {
            request.addParameter("RoleName", StringConversion.fromString((String)importSnapshotRequest.roleName()));
        }
        return request;
    }
}

